{
    layouts {

    	;; valid layers: backdrop, emptyfloor, wallpaper, worker, deco, walker, foreground
    	;; valid states: open, closed, broken, construction
        ;; ALWAYS set up animation positions to go L-R bottom THEN L-R top


    	layout-missing {
    		open [ { img "missing.png" layer wallpaper atlas hddecos } ]
    	}

    	;; ------------------------------------------------------------------

    	;; stairs and elevators

    	layout-elevator {
    		open [
                { img "path-elevator-open.png" layer wallpaper atlas hdwalls }
    			{ img "path-stairs-left.png" layer foreground atlas hddecos }
            ]
    		closed [
                { img "path-elevator-closed.png" layer wallpaper atlas hdwalls }
    			{ img "path-stairs-left.png" layer foreground atlas hddecos }
            ]
    		broken [
                { img "path-elevator-broken.png" layer wallpaper atlas hdwalls }
            ]
    		construction [
                { img "path-elevator-uc.png" layer wallpaper atlas hdwalls }
    			{ img "path-stairs-left.png" layer foreground atlas hddecos }
            ]
    	}
        layout-elevator-fancy {
            open [
                { img "path-elevator-fancy-open.png" layer wallpaper atlas hdwalls }
                { img "elevator-fancy-left.png" layer foreground atlas hddecos }
            ]
            closed [
                { img "path-elevator-fancy-closed.png" layer wallpaper atlas hdwalls }
                { img "elevator-fancy-left.png" layer foreground atlas hddecos }
            ]
            broken [
                { img "path-elevator-fancy-broken.png" layer wallpaper atlas hdwalls }
            ]
            construction [
                { img "path-elevator-uc.png" layer wallpaper atlas hdwalls }
                { img "path-stairs-left.png" layer foreground atlas hddecos }
            ]
        }
    	layout-stairs {
    		open [
                { img "stairwell.png" layer wallpaper atlas hdwalls }
                { img "stairs-props.png" dx 18 layer deco atlas hddecos }
    			{ img "path-stairs-left.png" layer deco atlas hddecos }
                { img "stairs-floor.png" layer deco atlas hddecos }
            ]
    		construction [
                { img "path-stairs-uc.png" layer wallpaper atlas hdwalls }
    			{ img "path-stairs-left.png" layer deco atlas hddecos }
                { img "stairs-props.png" dx 18 layer deco atlas hddecos }
                { img "stairs-floor.png" layer deco atlas hddecos }
            ]
    	}

    	layout-escalator {
    		open [
                { img "escalator.png" layer wallpaper atlas hdwalls }
                { img "escalator_front.png" layer deco atlas hddecos }
                { img "stairs-floor.png" layer deco atlas hddecos }
                { img "stairs-floor.png" layer foreground atlas hdwalls }
            ]
    		broken [
                { img "escalator.png" layer wallpaper atlas hdwalls }
                { img "escalator_front-broken.png" layer deco atlas hddecos }
                { img "stairs-floor.png" layer deco atlas hddecos }
                { img "stairs-floor.png" layer foreground atlas hdwalls }
            ]
    		construction [
                { img "escalator-UC.png" layer wallpaper atlas hdwalls }
                { img "escalator_front.png" layer deco atlas hddecos }
                { img "stairs-floor.png" layer deco atlas hddecos }
                { img "stairs-floor.png" layer foreground atlas hdwalls }
            ]
    	}
        layout-path-blocker {
            open [
                { img "amenity-phones.png" layer wallpaper atlas hdservices }
                { img "missing.png" dx 50 dy 50 layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "missing.png" dx 50 dy 50 layer foreground atlas hddecos }
            ]
        }



    	;; ------------------------------------------------------------------

    	;; closets

    	closet-electrical-layout {
			open [
                { img "wirecloset.png" layer wallpaper atlas hdwalls }
            ]
    	}
    	closet-plumbing-layout {
			open [
                { img "plumbingcloset.png" layer wallpaper atlas hdwalls }
            ]
    	}
    	closet-watermeter-l1 {
			open [
                { img "meter-water-l1.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
    		construction [
                { img "meter-uc-l1.png" layer wallpaper atlas hdwalls }
            ]
    	}
    	closet-watermeter-l2 {
			open [
                { img "meter-water-l2.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
    		construction [
                { img "meter-uc-l2.png" layer wallpaper atlas hdwalls }
            ]
    	}
        closet-watermeter-l3 {
            open [
                { img "meter-water-l3.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "meter-uc-l3.png" layer wallpaper atlas hdwalls }
            ]
        }
    	closet-gasmeter-l1 {
			open [
                { img "meter-gas-l1.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
    		construction [
                { img "meter-uc-l1.png" layer wallpaper atlas hdwalls }
            ]
    	}
    	closet-gasmeter-l2 {
			open [
                { img "meter-gas-l2.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
    		construction [
                { img "meter-uc-l2.png" layer wallpaper atlas hdwalls }
            ]
    	}
        closet-gasmeter-l3 {
            open [
                { img "meter-gas-l3.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "meter-uc-l3.png" layer wallpaper atlas hdwalls }
            ]
        }
    	closet-powermeter-l1 {
    		open [
                { img "meter-power-l1.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
    		construction [
                { img "meter-uc-l1.png" layer wallpaper atlas hdwalls }
            ]
    	}
    	closet-powermeter-l2 {
    		open [
                { img "meter-power-l2.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
    		construction [
                { img "meter-uc-l2.png" layer wallpaper atlas hdwalls }
            ]
    	}
        closet-powermeter-l3 {
            open [
                { img "meter-power-l3.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "meter-uc-l3.png" layer wallpaper atlas hdwalls }
            ]
        }
    	closet-phonemeter-l1 {
    		open [
                { img "meter-phone-l1.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
    		construction [
                { img "meter-uc-l1.png" layer wallpaper atlas hdwalls }
            ]
    	}
        closet-phonemeter-l2 {
            open [
                { img "meter-phone-l2.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "meter-uc-l2.png" layer wallpaper atlas hdwalls }
            ]
        }
        closet-phonemeter-l3 {
            open [
                { img "meter-phone-l3.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "meter-uc-l3.png" layer wallpaper atlas hdwalls }
            ]
        }
    	closet-cablemeter-l1 {
    		open [
                { img "meter-cable-l1.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
    		construction [
                { img "meter-uc-l1.png" layer wallpaper atlas hdwalls }
            ]
    	}
        closet-cablemeter-l2 {
            open [
                { img "meter-cable-l2.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "meter-uc-l2.png" layer wallpaper atlas hdwalls }
            ]
        }
        closet-cablemeter-l3 {
            open [
                { img "meter-cable-l3.png" layer wallpaper atlas hdwalls }
                { img "meters_left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "meter-uc-l3.png" layer wallpaper atlas hdwalls }
            ]
        }



    	;; ------------------------------------------------------------------

    	;; emptyspace

    	emptyoffice-four-wide {
    		open [
                { img "zoned-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "zoned-office-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-office-1w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "empty-office.png" dx 75 layer deco atlas hddecos }
            ]
    	}
    	emptyoffice-ten-wide {
    		open [
                { img "zoned-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "zoned-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "empty-office.png" dx 175 layer deco atlas hddecos }
                { img "empty-office.png" dx 375 layer deco atlas hddecos }
            ]
    	}
        emptyoffice-fifteen-wide {
            open [
                { img "zoned-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "zoned-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "zoned-office-1w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "empty-office.png" dx 175 layer deco atlas hddecos }
                { img "empty-office.png" dx 375 layer deco atlas hddecos }
                { img "empty-office.png" dx 575 layer deco atlas hddecos }
            ]
        }
        emptyoffice-ten-wide-two-tall {
            open [
                { img "middlefloor-10w.png" dy 146 layer worker atlas hdwalls }
                { img "zoned-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-left-second-office.png" layer foreground atlas hddecos }
                { img "zoned-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-door-second-office.png" dy 146 layer wallpaper atlas hdwalls }
                { img "zoned-office-1w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dy 150 dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dy 150 dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dy 150 dx 300 layer wallpaper atlas hdwalls }
                { img "zoned-office-2w.png" dy 150 dx 400 layer wallpaper atlas hdwalls }
                { img "empty-office.png" dx 175 layer deco atlas hddecos }
                { img "empty-office.png" dy 150 dx 375 layer deco atlas hddecos }
            ]
        }
        emptyapartment-six-wide {
            open [
                { img "zoned-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "zoned-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "empty-apartment.png" dx 175 layer deco atlas hddecos }
            ]
        }
        emptyapartment-eight-wide {
            open [
                { img "zoned-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "zoned-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "empty-apartment.png" dx 275 layer deco atlas hddecos }
            ]
        }
        emptyapartment-ten-wide {
            open [
                { img "zoned-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "zoned-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "empty-apartment.png" dx 375 layer deco atlas hddecos }
            ]
        }
        emptyapartment-sixteen-wide {
            open [
                { img "zoned-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "zoned-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "empty-apartment.png" dx 475 layer deco atlas hddecos }
                { img "empty-apartment.png" dx 675 layer deco atlas hddecos }
            ]
        }
        emptyapartment-ten-wide-two-tall {
            open [
                { img "zoned-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-door-second-res.png" dy 146 layer worker atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "zoned-left-second-res.png" dy 146 layer foreground atlas hddecos }
                { img "zoned-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-1w-second-res.png" dx 50 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-res.png" dx 100 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-res.png" dx 200 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-res.png" dx 300 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-res.png" dx 400 dy 146 layer worker atlas hdwalls }
                { img "empty-apartment.png" dx 175 dy 150 layer deco atlas hddecos }
                { img "empty-apartment.png" dx 375 dy 150 layer deco atlas hddecos }
            ]
        }
        emptyapartment-fifteen-wide-two-tall {
            open [
                { img "zoned-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-door-second-res.png" dy 146 layer worker atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "zoned-left-second-res.png" dy 146 layer foreground atlas hddecos }
                { img "zoned-res-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 350 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 550 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 650 layer wallpaper atlas hdwalls }
                { img "zoned-2w-second-res.png" dx 50 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-res.png" dx 150 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-res.png" dx 250 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-res.png" dx 350 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-res.png" dx 450 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-res.png" dx 550 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-res.png" dx 650 dy 146 layer worker atlas hdwalls }
                { img "empty-apartment.png" dx 175 dy 150 layer deco atlas hddecos }
                { img "empty-apartment.png" dx 375 dy 150 layer deco atlas hddecos }
            ]
        }
        emptyapartment-rooftop-fourteen-wide {
            open [
                { img "roof-railing-left.png" dx 0 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 50 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 100 layer foreground atlas hdwalls }
                { img "roof-railing-right.png" dx 150 layer foreground atlas hdwalls }
                { img "zoned-res-door.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 350 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 550 layer wallpaper atlas hdwalls }
                { img "zoned-res-1w.png" dx 650 layer wallpaper atlas hdwalls }
                { img "empty-apartment.png" dx 425 layer deco atlas hddecos }
            ]
        }
        emptyapartment-rooftop-twenty-wide {
            open [
                { img "roof-railing-left.png" dx 0 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 50 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 100 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 150 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 200 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 250 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 300 layer foreground atlas hdwalls }
                { img "roof-railing-right.png" dx 350 layer foreground atlas hdwalls }
                { img "zoned-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 800 layer wallpaper atlas hdwalls }
                { img "zoned-res-2w.png" dx 900 layer wallpaper atlas hdwalls }

            ]
        }
    	emptyrestaurant-four-wide {
    		open [
                { img "zoned-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "zoned-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "empty-restaurant.png" dx 75 layer deco atlas hddecos }
            ]
    	}
        emptyrestaurant-eight-wide {
            open [
                { img "zoned-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "zoned-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "empty-restaurant.png" dx 275 layer deco atlas hddecos }
            ]
        }
        emptyrestaurant-sixteen-wide {
            open [
                { img "zoned-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "zoned-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "empty-restaurant.png" dx 675 layer deco atlas hddecos }
            ]
        }
        emptyrestaurant-fourteen-wide {
            open [
                { img "zoned-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "zoned-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "empty-restaurant.png" dx 350 layer deco atlas hddecos }
            ]
        }
        emptyrestaurant-rooftop-twelve-wide {
            open [
                { img "roof-railing-left.png" layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 50 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 100 layer foreground atlas hdwalls } 
                { img "roof-railing-middle.png" dx 150 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 200 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 250 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 300 layer foreground atlas hdwalls }
                { img "roof-railing-right.png" dx 350 layer foreground atlas hdwalls }
                { img "zoned-restaurant-door.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-1w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "empty-restaurant.png" dx 475 layer deco atlas hddecos }
            ]
        }
        emptyrestaurant-rooftop-eighteen-wide {
            open [
                { img "zoned-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "roof-railing-right.png" dx 300 layer foreground atlas hdwalls hflip #true }
                { img "roof-railing-middle.png" dx 350 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 400 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 450 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 500 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 550 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 600 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 650 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 700 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 750 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 800 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 850 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 900 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 950 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 1000 layer foreground atlas hdwalls }
                { img "roof-railing-left.png" dx 1050 layer foreground atlas hdwalls hflip #true }
                { img "empty-restaurant.png" dx 150 layer deco atlas hddecos }
            ]
        }

        emptyretail-seven-wide {
            open [
                { img "zoned-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "zoned-retail-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "empty-retail.png" dx 200 layer deco atlas hddecos }
            ]
        }
        emptyretail-twelve-wide {
            open [
                { img "zoned-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "zoned-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "empty-retail.png" dx 350 layer deco atlas hddecos }
            ]
        }
        emptyretail-twelve-wide-two-tall {
            open [
                { img "zoned-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-door-second-retail.png" dy 146 layer worker atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "zoned-left-second-retail.png" dy 146 layer foreground atlas hddecos }
                { img "zoned-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "zoned-1w-second-retail.png" dx 50 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-retail.png" dx 100 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-retail.png" dx 200 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-retail.png" dx 300 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-retail.png" dx 400 dy 146 layer worker atlas hdwalls }
                { img "zoned-2w-second-retail.png" dx 500 dy 146 layer worker atlas hdwalls }
                { img "empty-retail.png" dx 150 layer deco atlas hddecos }
                { img "empty-retail.png" dx 350 layer deco atlas hddecos }
                { img "empty-retail.png" dx 200 dy 150 layer deco atlas hddecos }
            ]
        }
        emptyretail-eight-wide {
            open [
                { img "zoned-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "zoned-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "zoned-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "empty-retail-l4.png" dx 200 layer deco atlas hddecos }
            ]
        }


    	;; ------------------------------------------------------------------

    	;; maintenance and stuff

    	maintenance-office-layout {
			open [
				{ img "support-repair.png" layer wallpaper atlas hdwalls }
				{ img "maintenance-left.png" layer foreground atlas hddecos }
			]
			construction  [ 
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
				{ img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-pallet-drywall.png" dx 29 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dy 36 dx 68 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 127 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 161 layer deco atlas hddecos }
            ]
            workstations [ { dx 55 anim peepworkr } { dx 95 anim peepworkf }  ]
    	}
        expanded-maintenance-office-layout {
            open [
                { img "support-repair-expanded.png" layer wallpaper atlas hdwalls }
                { img "maintenance-left.png" layer foreground atlas hddecos }
                { img "support-repair-props.png" dx 28 layer deco atlas hddecos }
                { img "chair-work-1.png" dx 144 layer deco atlas hddecos }
            ]
            construction  [ 
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-pallet-drywall.png" dx 29 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dy 36 dx 68 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 127 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 161 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 210 layer deco atlas hddecos }
            ]
            workstations [ { dx 85 anim peepworkf } { dx 145 anim peepworkl } { dx 270 anim peepworkb }  ]
        }

    	builders-office-layout {
			open [
				{ img "support-construction.png" layer wallpaper atlas hdwalls }
                { img "chair-work-1.png" dx 137 layer deco atlas hddecos }
                { img "maintenance-left.png" layer foreground atlas hddecos }
			]
			workstations [ { dx 78 anim peepworkr } { dx 145 anim peepworkl } ]
    	}
        builders-office-expanded-layout {
            open [
                { img "support-construction-expanded.png" layer wallpaper atlas hdwalls }
                { img "maintenance-left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-planks-tools.png" dx 91 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 145 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dy 116 dx 161 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 198 layer deco atlas hddecos }
            ]

            workstations [ { dx 126 anim peepworkr } { dx 181 anim peepworkf } { dx 220 anim peepworkf } ]
        }

        support-trashbin {
            open [ 
                { img "support-trash-bin.png" layer wallpaper atlas hdres }
                { img "trash-left.png" layer foreground atlas hddecos }
                { img "support-trash-bin-props-empty.png" dx 28 layer worker atlas hddecos } 
            ]
            closed [ 
                { img "support-trash-bin.png" layer wallpaper atlas hdres }
                { img "trash-left.png" layer foreground atlas hddecos }
                { img "support-trash-bin-props-full.png" dx 28 layer worker atlas hddecos } 
            ]
            construction [ 
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "floor-basement-3.png" layer wallpaper atlas hdwalls dx 50 }
                { img "prop-garbagebin-empty.png" layer foreground atlas hddecos dx 15 } 
                ;{ img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
            ]
        }
        support-recyclebin {
            open [ 
                { img "support-recycle-bin.png" layer wallpaper atlas hdres }
                { img "trash-left.png" layer foreground atlas hddecos }
                { img "support-recycle-bin-props-empty.png" dx 24 layer worker atlas hddecos } 
            ]
            closed [ 
                { img "support-recycle-bin.png" layer wallpaper atlas hdres }
                { img "trash-left.png" layer foreground atlas hddecos }
                { img "support-recycle-bin-props-full.png" dx 24 layer worker atlas hddecos }
            ]
            construction [ 
                { img "floor-basement-3.png" layer wallpaper atlas hdwalls }
                { img "support-recycle-bin-props-empty.png" dx 24 layer deco atlas hddecos } 
            ]
        }
        support-trashroom {
            open [ 
                { img "support-trash-room.png" layer wallpaper atlas hdres }
                { img "trash-left.png" layer foreground atlas hddecos }
                { img "support-trash-room-props-empty.png" dx 112 layer worker atlas hddecos }
            ]
            closed [ 
                { img "support-trash-room.png" layer wallpaper atlas hdres }
                { img "trash-left.png" layer foreground atlas hddecos }
                { img "support-trash-room-props-full.png" dx 105.5 layer worker atlas hddecos } 
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-shovel.png" dx 39 layer deco atlas hddecos } 
                { img "uc-pallet-concrete.png" dx 52 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 125 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 160 layer deco atlas hddecos }
                { img "uc-light.png" dx 190 layer deco atlas hddecos }
             ]
             workstations [
                { dx 52 anim peepworkf }
            ]
        }
        support-recycle {
            open [ 
                { img "support-trash-room.png" layer wallpaper atlas hdres }
                { img "trash-left.png" layer foreground atlas hddecos }
                { img "support-recycle-room-props-empty.png" dx 97 layer worker atlas hddecos } 
            ]
            closed [ 
                { img "support-trash-room.png" layer wallpaper atlas hdres }
                { img "trash-left.png" layer foreground atlas hddecos }
                { img "support-recycle-room-props-full.png" dx 97 layer worker atlas hddecos } 
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-shovel.png" dx 39 layer deco atlas hddecos } 
                { img "uc-pallet-concrete.png" dx 52 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 125 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 160 layer deco atlas hddecos }
                { img "uc-light.png" dx 199 layer deco atlas hddecos }
            ]
            workstations [
                { dx 52 anim peepworkf }
            ]
        }

        support-loadingdock {
            open [ 
                { img "support-dock.png" layer wallpaper atlas hdwalls }
                { img "service-left-2.png" layer foreground atlas hddecos }
                { img "support-dock-props-right.png" dx 29 layer deco atlas hddecos }
                { img "support-dock-shelves.png" dx 147 layer deco atlas hddecos }
                { img "support-dock-bay-one.png" dx 147 layer deco atlas hddecos }
                { img "support-dock-bay-two.png" dx 147 layer deco atlas hddecos }
                { img "support-dock-bay-three.png" dx 147 layer deco atlas hddecos }
                { img "support-dock-bay-four.png" dx 147 layer deco atlas hddecos }
                { img "support-dock-lights.png" dy 126 dx 144 layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-planks-tools.png" dx 91 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 145 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dy 116 dx 161 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 30 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 200 layer deco atlas hddecos }
                { img "uc-pallet-concrete.png" dx 312 layer deco atlas hddecos }
                { img "uc-shovel.png" dx 278 layer deco atlas hddecos }
                { img "uc-light.png" dx 402 layer deco atlas hddecos }
             ]
             workstations [ { dx 75 anim peepworkf } ]
        }
;        support-loadingdock-expanded {
;            open [
;                { img "support-dock-expanded.png" layer wallpaper atlas hdwalls }
;                { img "uc-left.png" layer foreground atlas hddecos }
;                { img "service-left-2.png" layer foreground atlas hddecos }
;                { img "support-dock-props-right.png" dx 29 layer deco atlas hddecos }
;                { img "support-dock-shelves.png" dx 147 layer deco atlas hddecos }
;                { img "support-dock-expanded-shelves.png" dx 510 layer deco atlas hddecos }
;                { img "uc-dolly.png" dx 423.5 layer deco atlas hddecos }
;                { img "uc-dolly.png" dx 624 layer deco atlas hddecos }
;                { img "support-dock-expanded-lights.png" dy 126 dx 131 layer foreground atlas hddecos }
;            ]
;            closed [
;                { img "support-dock-expanded.png" layer wallpaper atlas hdwalls }
;                { img "service-left-2.png" layer foreground atlas hddecos }
;                { img "support-dock-props-right.png" dx 29 layer deco atlas hddecos }                
;                { img "support-dock-bay-four.png" dx 147 layer deco atlas hddecos }
;                { img "support-dock-bay-six.png" dx 510 layer deco atlas hddecos }
;                { img "support-dock-expanded-lights.png" dy 126 dx 131 layer foreground atlas hddecos }
;            ]
;            construction [
;                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
;                { img "uc-left.png" layer foreground atlas hddecos }
;                { img "uc-1w.png" dx 50 layer wallpaper atlas hdwalls }
;                { img "uc-2w.png" dx 100 layer wallpaper atlas hdwalls }
;                { img "uc-2w.png" dx 200 layer wallpaper atlas hdwalls }
;                { img "uc-2w.png" dx 300 layer wallpaper atlas hdwalls }
;                { img "uc-2w.png" dx 400 layer wallpaper atlas hdwalls }
;                { img "uc-2w.png" dx 500 layer wallpaper atlas hdwalls }
;                { img "uc-2w.png" dx 600 layer wallpaper atlas hdwalls }
;                { img "uc-pallet-planks.png" dx 51 layer deco atlas hddecos }
;                { img "uc-toolbox.png" dy 44 dx 90 layer deco atlas hddecos }
;                { img "uc-planks-tools.png" dx 130 layer deco atlas hddecos }
;                { img "uc-trash-open.png" dx 191 layer deco atlas hddecos }
;                { img "uc-bucket-paint.png" dx 229 layer deco atlas hddecos }
;                { img "uc-toolbox-hammer.png" dx 256 layer deco atlas hddecos }
;                { img "uc-buckets-paint.png" dx 293 layer deco atlas hddecos }
;                { img "uc-pallet-concrete.png" dx 317 layer deco atlas hddecos }
;                { img "uc-drywall-tools.png" dx 528 layer deco atlas hddecos }
;                { img "uc-toolbox-open.png" dx 595 layer deco atlas hddecos }
;                { img "uc-light.png" dx 630 layer deco atlas hddecos }
;             ]
;             workstations [ { dx 75 anim peepworkf } ]
;        }


    	;; -------------------------------------------------------------------

    	;; residences

        residence-level-one-studio-med {
            open [
                { img "res-1-studio-a.png" layer wallpaper atlas hdres }
                { img "metal-bed-front.png" dx 179 layer deco atlas hddecos }
                { img "res-studio-low-left.png" layer foreground atlas hddecos }
                { img "grime-1a.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 50 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 250 layer grime atlas hdgrime }
             ]
            construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-crate-tv.png" dx 19 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 108 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 141 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 236 layer deco atlas hddecos }
             ]
            residentanchors [
                { dx 87 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 115 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 175 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 228 animm "sleep-c-m" animf "sleep-c-f" sleep #true }
            ]
        }
    	residence-level-one-studio-high {
    		open [
                { img "res-1-studio-b.png" layer wallpaper atlas hdres }
				{ img "res-studio-med-left.png" layer foreground atlas hddecos }
                { img "metal-bed-front.png" dx 177 layer deco atlas hddecos }
                { img "grime-1b.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 50 layer grime atlas hdgrime }
                { img "grime-1b.png" dx 250 layer grime atlas hdgrime }
            ]
    		construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-drywall-tools.png" dx 25 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 75 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 107 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 136 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 219 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 180 dy 57 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 236 dy 38.5 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 54 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 109 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 245 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 226 animm "sleep-b-m" animf "sleep-b-f" sleep #true }
            ]
            serviceanchors [
                { dx 108 tasktype serviceplumber } { dx 170 tasktype servicehandyman }
            ]
    	}
        residence-level-one-studio-lux {
            open [
                { img "res-1-studio-c.png" layer wallpaper atlas hdres }
                { img "res-studio-high-left.png" layer foreground atlas hddecos }
                { img "brown-bed-single-front.png" dx 180 layer deco atlas hddecos }
                { img "grime-1a.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 50 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 250 layer grime atlas hdgrime }
             ]
            construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-crate-tv.png" dx 19 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 108 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 141 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 236 layer deco atlas hddecos }
             ]
            residentanchors [
                { dx 70 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" }
                { dx 274 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 233 animm "sleep-c-m" animf "sleep-c-f" sleep #true }
            ]
            serviceanchors [
                { dx 175 tasktype servicehandyman } { dx 59 }
            ]
        }


    	residence-level-one-low {
    		open [
                { img "res-1-1br-a.png" layer wallpaper atlas hdres }
				{ img "res-studio-low-left.png" layer foreground atlas hddecos }
                { img "metal-bed-front-double.png" dx 264 layer deco atlas hddecos }
                { img "grime-1a.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 50 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 200 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 350 layer grime atlas hdgrime }                
            ]
    		construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-pallet-drywall.png" dx 19 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 121 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 180 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 260 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 314 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 64 dy 26 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 137 dy 116.5 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 185 dy 38.5 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 260 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 353 dy 58.5 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 138 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 170 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 280 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 315 animm "sleep-c-m" animf "sleep-c-f" sleep #true }
                { dx 340 animm "sleep-c-m" animf "sleep-c-f" sleep #true }
            ]
            serviceanchors [
                { dx 263 tasktype servicehandyman }
                { dx 263 tasktype serviceplumber }
            ]
    	}
        residence-level-one-med {
            open [
                { img "res-1-1br-b.png" layer wallpaper atlas hdres }
                { img "res-1b-left.png" layer foreground atlas hddecos }
                { img "brown-bed-double-l1-front.png" dx 261.5 dy -0.5 layer deco atlas hddecos }
                { img "grime-1a.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 50 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 200 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 350 layer grime atlas hdgrime }                
            ]
            construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-pallet-drywall.png" dx 19 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 121 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 180 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 260 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 314 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 64 dy 26 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 137 dy 116.5 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 185 dy 38.5 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 260 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 353 dy 58.5 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 68 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" }
                { dx 100 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 129 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 314 animm "sleep-c-m" animf "sleep-c-f" sleep #true }
                { dx 341 animm "sleep-c-m" animf "sleep-c-f" sleep #true }
            ]
            serviceanchors [
                { dx 263 tasktype servicehandyman }
                { dx 263 tasktype serviceplumber }
            ]
        }

    	residence-level-one-high {
    		open [
                { img "res-1-1br-c.png" layer wallpaper atlas hdres }
				{ img "res-1b-left.png" layer foreground atlas hddecos }
                { img "res-1br-c-props.png" dx 91 layer deco atlas hddecos }
                { img "brown-bed-double-l1-front.png" dx 261.5 dy -0.5 layer deco atlas hddecos }
                { img "grime-1b.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 50 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-1b.png" dx 350 layer grime atlas hdgrime }
            ]
    		construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-pallet-drywall.png" dx 19 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 121 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 180 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 260 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 314 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 64 dy 26 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 137 dy 116.5 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 185 dy 38.5 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 260 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 353 dy 58.5 layer deco atlas hddecos }
            ]
            residentanchors [
               { dx 68 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" }
                { dx 100 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 155 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 314 animm "sleep-c-m" animf "sleep-c-f" sleep #true }
                { dx 341 animm "sleep-c-m" animf "sleep-c-f" sleep #true }
            ]
            serviceanchors [
                { dx 250 tasktype servicehandyman }
                { dx 250 tasktype serviceplumber }
                { dx 366 tasktype servicelaundry }
            ]
    	}
        ;; two
        residence-level-two-low {
            open [
                { img "res-2-2br-a.png" layer wallpaper atlas hdres }
                { img "res-2a-left.png" layer foreground atlas hddecos }
                { img "brown-bed-double-l2-front.png" dx 218.5 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 150 layer grime atlas hdgrime }
                { img "grime-2a.png" dx 350 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 9 layer deco atlas hddecos hflip #true }
                { img "uc-crate-long.png" dx 71 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 158 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 242 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 273 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 324 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 358 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 411 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 71 dy 48 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 195 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 273 dy 93.5 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 445 dy 36 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 100 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 150 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 415 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 258 animm "sleep-b-m" animf "sleep-b-f" sleep #true }
                { dx 292 animm "sleep-b-m" animf "sleep-b-f" sleep #true }
            ]
            serviceanchors [
                { dx 80 tasktype servicehandyman }
                { dx 150 tasktype serviceplumber }
                { dx 330 tasktype servicelaundry }
                { dx 250 plusorminus 150 tasktype servicecleaning }
            ]
        }
        residence-level-two-low-kids {
            open [
                { img "res-2-2br-a-kids.png" layer wallpaper atlas hdres }
                { img "res-2a-left.png" layer foreground atlas hddecos }
                { img "brown-bed-double-l2-front.png" dx 220 atlas hddecos layer deco }
                { img "brown-bed-single-front.png" dx 372 layer deco atlas hddecos }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 150 layer grime atlas hdgrime }
                { img "grime-2b.png" dx 350 layer grime atlas hdgrime }
                { img "grime-1b.png" dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 9 layer deco atlas hddecos hflip #true }
                { img "uc-crate-long.png" dx 71 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 158 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 242 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 273 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 324 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 358 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 411 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 71 dy 48 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 195 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 273 dy 93.5 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 445 dy 36 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 55 animm "res-stand-back-m" animf "res-stand-back-f" adultonly #true }
                { dx 145 animm "res-stand-back-m" animf "res-stand-back-f" adultonly #true }
                { dx 475 animm "play-m" animf "play-f" childonly #true }
                { dx 400 animm "play-m" animf "play-f" childonly #true }
                { dx 260 animm "sleep-b-m" animf "sleep-b-f" sleep #true adultonly #true }
                { dx 288 animm "sleep-b-m" animf "sleep-b-f" sleep #true adultonly #true }
                { dx 428 animm "sleep-b-m" animf "sleep-b-f" sleep #true childonly #true }
            ]
            serviceanchors [
                { dx 60 tasktype servicehandyman }
                { dx 143 tasktype serviceplumber }
                { dx 330 tasktype servicelaundry }
                { dx 250 plusorminus 150 tasktype servicecleaning }
            ]
        }
         residence-level-two-low-office {
            open [
                { img "res-2-2br-a-office.png" layer wallpaper atlas hdres }
                { img "res-2a-left.png" layer foreground atlas hddecos }
                { img "brown-bed-double-l2-front.png" dx 172 layer deco atlas hddecos }
                { img "chair-desk-11.png" dx 430 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 150 layer grime atlas hdgrime }
                { img "grime-2a.png" dx 350 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 9 layer deco atlas hddecos hflip #true }
                { img "uc-crate-long.png" dx 71 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 158 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 242 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 273 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 324 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 358 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 411 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 71 dy 48 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 195 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 273 dy 93.5 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 445 dy 36 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 42 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 100 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 447 animm "res-work-m" animf "res-work-f" }
                { dx 210 animm "sleep-b-m" animf "sleep-b-f" sleep #true }
                { dx 242 animm "sleep-b-m" animf "sleep-b-f" sleep #true }
            ]
            serviceanchors [
                { dx 50 tasktype servicehandyman }
                { dx 92 tasktype serviceplumber }
                { dx 330 tasktype servicelaundry }
                { dx 250 plusorminus 150 tasktype servicecleaning }
            ]
        }
        residence-level-two-high {
            open [
                { img "res-2-2br-b.png" layer wallpaper atlas hdres }
                { img "res-2b-left.png" layer foreground atlas hddecos }
                { img "brown-bed-double-l2-front.png" dx 219.5 layer deco atlas hddecos }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 150 layer grime atlas hdgrime }
                { img "grime-2b.png" dx 350 layer grime atlas hdgrime }
                { img "grime-1b.png" dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 9 layer deco atlas hddecos hflip #true }
                { img "uc-crate-long.png" dx 71 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 158 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 242 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 273 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 324 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 358 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 411 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 71 dy 48 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 195 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 273 dy 93.5 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 445 dy 36 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 66 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" }
                { dx 121 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 255 animm "sleep-b-m" animf "sleep-b-f" sleep #true }
                { dx 288 animm "sleep-b-m" animf "sleep-b-f" sleep #true }
            ]
            serviceanchors [
                { dx 167 tasktype servicehandyman }
                { dx 250 tasktype serviceplumber }
                { dx 330 tasktype servicelaundry }
                { dx 50 tasktype servicedogs }
                { dx 250 plusorminus 150 tasktype servicecleaning }
            ]
        }
        residence-level-two-high-kids {
            open [
                { img "res-2-2br-b-kids.png" layer wallpaper atlas hdres }
                { img "res-2b-left.png" layer foreground atlas hddecos }
                { img "brown-bed-double-l2-front.png" dx 218 layer deco atlas hddecos }
                { img "brown-bed-single-front.png" dx 371 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 150 layer grime atlas hdgrime }
                { img "grime-2a.png" dx 350 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 350 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 9 layer deco atlas hddecos hflip #true }
                { img "uc-crate-long.png" dx 71 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 158 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 242 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 273 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 324 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 358 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 411 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 71 dy 48 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 195 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 273 dy 93.5 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 445 dy 36 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 57 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" adultonly #true }
                { dx 150 animm "res-stand-back-m" animf "res-stand-back-f" adultonly #true }
                { dx 475 animm "play-m" animf "play-f" childonly #true }
                { dx 400 animm "play-m" animf "play-f" childonly #true }
                { dx 254 animm "sleep-b-m" animf "sleep-b-f" sleep #true adultonly #true }
                { dx 288 animm "sleep-b-m" animf "sleep-b-f" sleep #true adultonly #true }
                { dx 428 animm "sleep-b-m" animf "sleep-b-f" sleep #true childonly #true }
            ]
            serviceanchors [
                { dx 190 tasktype servicehandyman }
                { dx 250 tasktype serviceplumber }
                { dx 330 tasktype servicelaundry }
                { dx 50 tasktype servicedogs }
                { dx 250 plusorminus 150 tasktype servicecleaning }
            ]
        }
        residence-level-two-high-office {
            open [
                { img "res-2-2br-b-office.png" layer wallpaper atlas hdres }
                { img "res-2b-left.png" layer foreground atlas hddecos }
                { img "brown-bed-double-l2-front.png" dx 171 layer deco atlas hddecos }
                { img "chair-desk-11.png" dx 438 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 150 layer grime atlas hdgrime }
                { img "grime-2a.png" dx 350 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 9 layer deco atlas hddecos hflip #true }
                { img "uc-crate-long.png" dx 71 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 158 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 242 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 273 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 324 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 358 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 411 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 71 dy 48 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 195 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 273 dy 93.5 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 445 dy 36 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 57 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" }
                { dx 455 animm "res-work-m" animf "res-work-f" }
                { dx 207 animm "sleep-b-m" animf "sleep-b-f" sleep #true }
                { dx 242 animm "sleep-b-m" animf "sleep-b-f" sleep #true }
            ]
            serviceanchors [
                { dx 115 tasktype servicehandyman }
                { dx 200 tasktype serviceplumber }
                { dx 275 tasktype servicelaundry }
                { dx 50 tasktype servicedogs }
                { dx 250 plusorminus 150 tasktype servicecleaning }
            ]
        }
        residence-level-three-low-kids {
            open [
                { img "res-3a-kids.png" layer wallpaper atlas hdres }
                { img "res-3a-left.png" layer foreground atlas hddecos }
                { img "res-3-props.png" dx 100 layer deco atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 100 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 300 layer grime atlas hdgrime }                
                { img "grime-1a.png" dx 450 layer grime atlas hdgrime }
                { img "grime-2b.png" dx 500 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 600 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 29 layer deco atlas hddecos hflip #true }
                { img "uc-pallet-planks.png" dx 93 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 133 dy 42 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 185 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 245 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 261 dy 39 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 340 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 370 dy 48 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 437 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 470 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 534 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 599 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 665 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 699 dy 36 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 95 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" adultonly #true }
                { dx 159 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" adultonly #true }
                { dx 238 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" adultonly #true }
                { dx 438 animm "res-stand-back-m" animf "res-stand-back-f" adultonly #true }
                { dx 551 animm "sleep-a-m" animf "sleep-a-f" sleep #true adultonly #true }
                { dx 593 animm "sleep-a-m" animf "sleep-a-f" sleep #true adultonly #true }
                { dx 754 animm "sleep-a-m" animf "sleep-a-f" sleep #true childonly #true }
                { dx 700 animm "play-m" animf "play-f" childonly #true }
            ]
            serviceanchors [
                { dx 400 plusorminus 25 tasktype servicehandyman }
                { dx 493 tasktype serviceplumber }
                { dx 400 plusorminus 250 tasktype servicecleaning }
                { dx 50 tasktype servicedrycleaning }
                { dx 740 tasktype servicedaycare }
            ]
        }
        residence-level-three-low-office {
            open [
                { img "res-3a-office.png" layer wallpaper atlas hdres }
                { img "res-3a-left.png" layer foreground atlas hddecos }
                { img "res-3-props.png" dx 100 layer deco atlas hddecos }
                { img "chair-desk-14.png" dx 638 layer deco atlas hddecos }
                { img "grime-2b.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 100 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 300 layer grime atlas hdgrime }                
                { img "grime-1b.png" dx 450 layer grime atlas hdgrime }
                { img "grime-2a.png" dx 500 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 600 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 29 layer deco atlas hddecos hflip #true }
                { img "uc-pallet-planks.png" dx 93 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 133 dy 42 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 185 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 245 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 261 dy 39 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 340 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 370 dy 48 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 437 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 470 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 534 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 599 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 665 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 699 dy 36 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 54 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 95 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 159 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 238 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" }
                { dx 384 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 507 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
                { dx 552 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
                { dx 656 animm "res-work-m" animf "res-work-f" }
            ]
            serviceanchors [
                { dx 370 plusorminus 25 tasktype servicehandyman }
                { dx 450 tasktype serviceplumber }
                { dx 400 plusorminus 250 tasktype servicecleaning }
                { dx 50 tasktype servicedrycleaning }
                { dx 50 tasktype servicedaycare }
            ]
        }
        residence-level-three-medium-kids {
            open [
                { img "res-3b-kids.png" layer wallpaper atlas hdres }
                { img "res-3b-left.png" layer foreground atlas hddecos }
                { img "res-3-props.png" dx 96 layer deco atlas hddecos }
                { img "res-3b-props-center.png" dx 209 layer deco atlas hddecos }
                { img "chair-home-1.png" dx 638 layer deco atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 100 layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dx 300 layer grime atlas hdgrime hflip #true }                
                { img "grime-1a.png" dx 450 layer grime atlas hdgrime hflip #true }
                { img "grime-2b.png" dx 500 layer grime atlas hdgrime hflip #true }
                { img "grime-4b.png" dx 600 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 29 layer deco atlas hddecos hflip #true }
                { img "uc-pallet-planks.png" dx 93 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 133 dy 42 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 185 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 245 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 261 dy 39 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 340 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 370 dy 48 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 437 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 470 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 534 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 599 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 665 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 699 dy 36 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 99 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" adultonly #true }
                { dx 127 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" adultonly #true }
                { dx 168 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" adultonly #true }
                { dx 327 animm "res-stand-back-m" animf "res-stand-back-f" adultonly #true }
                { dx 524 animm "sleep-a-m" animf "sleep-a-f" sleep #true adultonly #true }
                { dx 565 animm "sleep-a-m" animf "sleep-a-f" sleep #true adultonly #true }
                { dx 747 animm "sleep-a-m" animf "sleep-a-f" sleep #true childonly #true }
                { dx 700 animm "play-m" animf "play-f" childonly #true }
            ]
            serviceanchors [
                { dx 300 plusorminus 25 tasktype servicehandyman }
                { dx 415 tasktype serviceplumber }
                { dx 400 plusorminus 250 tasktype servicecleaning }
                { dx 50 tasktype servicedrycleaning }
                { dx 50 tasktype servicetailor }
                { dx 740 tasktype servicedaycare }
                { dx 50 tasktype servicegym }
            ]
        }
        residence-level-three-medium-office {
            open [
                { img "res-3b-office.png" layer wallpaper atlas hdres }
                { img "res-3b-left.png" layer foreground atlas hddecos }
                { img "res-3-props.png" dx 96 layer deco atlas hddecos }
                { img "res-3b-props-center.png" dx 209 layer deco atlas hddecos }
                { img "chair-home-1.png" dx 638 layer deco atlas hddecos }
                { img "grime-2b.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 100 layer grime atlas hdgrime hflip #true }
                { img "grime-3b.png" dx 300 layer grime atlas hdgrime hflip #true }                
                { img "grime-1b.png" dx 450 layer grime atlas hdgrime hflip #true }
                { img "grime-2a.png" dx 500 layer grime atlas hdgrime hflip #true }
                { img "grime-4a.png" dx 600 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 29 layer deco atlas hddecos hflip #true }
                { img "uc-pallet-planks.png" dx 93 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 133 dy 42 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 185 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 245 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 261 dy 39 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 340 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 370 dy 48 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 437 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 470 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 534 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 599 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 665 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 699 dy 36 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 99 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 127 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 168 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 247 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 327 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 478 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
                { dx 522 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
                { dx 653 animm "res-work-m" animf "res-work-f" }
            ]
            serviceanchors [
                { dx 300 plusorminus 25 tasktype servicehandyman }
                { dx 415 tasktype serviceplumber }
                { dx 400 plusorminus 250 tasktype servicecleaning }
                { dx 50 tasktype servicedrycleaning }
                { dx 50 tasktype servicetailor }
                { dx 50 tasktype servicedaycare }
                { dx 50 tasktype servicegym }
            ]
        }
        residence-level-three-high-kids {
            open [
                { img "res-3c-kids.png" layer wallpaper atlas hdres }
                { img "res-3c-left.png" layer foreground atlas hddecos }
                { img "middlefloor-10w.png" dy 146 layer worker atlas hdwalls }
                { img "chair-home-1.png" dx 285 layer deco atlas hddecos }
                { img "res-3-props.png" dx 106 dy 150 layer deco atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 100 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 250 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime }
                { img "grime-2b.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 100 dy 150 layer grime atlas hdgrime }
                { img "grime-1b.png" dx 250 dy 150 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 300 dy 150 layer grime atlas hdgrime }
            ]
             construction [
                { img "zoned-left-second-res.png" layer foreground atlas hddecos }
                { img "middlefloor-10w.png" dy 146 layer worker atlas hdwalls }
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-door-second-res.png" dy 141.5 layer wallpaper atlas hdwalls }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-res-1w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 400 layer wallpaper atlas hdwalls }
                { img "uc-crate-long.png" dx 47 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 50 dy 48 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 94 dy 48 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 143 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 178 dy 39 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 227 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 276 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 294 dy 116.5 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 339 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 391 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 436 dy 36 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 50 dy 150 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 95 dy 208.5 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 136.5 dy 150 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 147 dy 208.5 layer deco atlas hddecos }
                { img "uc-pallet-planks.png" dx 200 dy 150 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 290 dy 150 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 359 dy 150 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 408 dy 150 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 272 dy 150 animm "sleep-a-m" animf "sleep-a-f" sleep #true adultonly #true }
                { dx 294 dy 150 animm "sleep-a-m" animf "sleep-a-f" sleep #true adultonly #true }
                { dx 452 dy 150 animm "sleep-a-m" animf "sleep-a-f" sleep #true childonly #true }
                { dx 400 dy 150 animm "play-m" animf "play-f" childonly #true }
                { dx 106 dy 150 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" adultonly #true }
                { dx 165 dy 150 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" adultonly #true }
                { dx 173 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" adultonly #true }
                { dx 389 animm "res-stand-back-m" animf "res-stand-back-f" adultonly #true }
            ]
            serviceanchors [
                { dx 389 plusorminus 20 tasktype servicehandyman }
                { dx 450 plusorminus 20 tasktype serviceplumber }
                { dx 340 plusorminus 100 tasktype servicecleaning }
                { dx 50 dy 150 tasktype servicedrycleaning }
                { dx 50 tasktype serviceflowers }
                { dx 50 dy 150 tasktype servicetailor }
                { dx 50 dy 150 tasktype servicedaycare }
                { dx 50 tasktype servicedogdaycare }
                { dx 50 tasktype servicegym }
            ]
        }
        residence-level-three-high-office {
            open [
                { img "res-3c-office.png" layer wallpaper atlas hdres }
                { img "res-3c-left.png" layer foreground atlas hddecos }
                { img "middlefloor-10w.png" dy 146 layer worker atlas hdwalls }
                { img "chair-home-1.png" dx 285 layer deco atlas hddecos }
                { img "res-3-props.png" dx 106 dy 150 layer deco atlas hddecos }
                { img "chair-home-1.png" dx 382 dy 150 layer deco atlas hddecos }
                { img "grime-2b.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 100 layer grime atlas hdgrime }
                { img "grime-1b.png" dx 250 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 300 layer grime atlas hdgrime }
                { img "grime-2a.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 100 dy 150 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 250 dy 150 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 300 dy 150 layer grime atlas hdgrime }
            ]
             construction [
                { img "zoned-left-second-res.png" layer foreground atlas hddecos }
                { img "middlefloor-10w.png" dy 146 layer worker atlas hdwalls }
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-door-second-res.png" dy 141.5 layer wallpaper atlas hdwalls }
                { img "uc-res-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-res-1w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 100 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 200 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 400 layer wallpaper atlas hdwalls }
                { img "uc-crate-long.png" dx 47 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 50 dy 48 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 94 dy 48 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 143 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 178 dy 39 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 227 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 276 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 294 dy 116.5 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 339 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 391 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 436 dy 36 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 50 dy 150 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 95 dy 208.5 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 136.5 dy 150 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 147 dy 208.5 layer deco atlas hddecos }
                { img "uc-pallet-planks.png" dx 200 dy 150 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 290 dy 150 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 359 dy 150 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 408 dy 150 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 272 dy 150 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
                { dx 294 dy 150 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
                { dx 106 dy 150 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 165 dy 150 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 173 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 389 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 397 dy 150 animm "res-work-m" animf "res-work-f" }
                { dx 272 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" }
            ]
            serviceanchors [
                { dx 389 plusorminus 20 tasktype servicehandyman }
                { dx 450 plusorminus 20 tasktype serviceplumber }
                { dx 340 plusorminus 100 tasktype servicecleaning }
                { dx 50 dy 150 tasktype servicedrycleaning }
                { dx 50 tasktype serviceflowers }
                { dx 50 dy 150 tasktype servicetailor }
                { dx 50 dy 150 tasktype servicedaycare }
                { dx 50 tasktype servicedogdaycare }
                { dx 50 tasktype servicegym }
            ]
        }

        residence-level-four-a {
            open [
                { img "res-4a.png" layer wallpaper atlas hdres }
                { img "res-4a-left.png" layer foreground atlas hddecos }
                { img "res-4a-left.png" dy 150 layer foreground atlas hddecos }
                { img "res-4a-props.png" dx 345 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 450 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 600 layer grime atlas hdgrime }
                { img "grime-4a.png" dy 150 layer grime atlas hdgrime }
                { img "grime-4b.png" dy 150 dx 200 layer grime atlas hdgrime hflip #true }
                { img "grime-1a.png" dy 150 dx 400 layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dy 150 dx 450 layer grime atlas hdgrime hflip #true }
                { img "grime-3b.png" dy 150 dx 600 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "zoned-left-second-res.png" layer foreground atlas hddecos }
                { img "middlefloor-15w.png" dy 146 layer worker atlas hdwalls }
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-door-second-res.png" dy 141.5 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 350 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 550 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 650 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 150 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 250 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 350 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 450 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 550 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 550 layer wallpaper atlas hdwalls }
                { img "uc-crate-chair.png" dx 51 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 144 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 213 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 250 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 304 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 363 layer deco atlas hddecos }
                { img "uc-toolbox.png" dx 459 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 500 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 595 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 635 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 667 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dy 150 dx 76 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dy 150 dx 171 layer deco atlas hddecos }
                { img "uc-box-4.png" dy 150 dx 235 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dy 150 dx 275 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dy 150 dx 335 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dy 150 dx 504 layer deco atlas hddecos }
                { img "uc-box-3.png" dy 150 dx 550 layer deco atlas hddecos }
                { img "uc-crate-short.png" dy 150 dx 595 layer deco atlas hddecos }
                { img "uc-trash-open.png" dy 150 dx 687 layer deco atlas hddecos }
            ]
            serviceanchors [
                { dx 50 tasktype servicedogs }
                { dx 50 tasktype servicegym }
                { dx 190 tasktype servicedecorator }
                { dx 50 dy 150 tasktype servicedrycleaning }
                { dx 50 dy 150 tasktype servicetailor }
                { dx 50 dy 150 tasktype servicedaycare }
                { dx 470 plusorminus 60 tasktype servicecleaning }
            ]
            residentanchors [
                { dx 199 dy 150 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 330 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" }
                { dx 559 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 675 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 376 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 433 dy 150 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
                { dx 654 dy 150 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
            ]
        }
        residence-level-four-kids {
            open [
                { img "res-4-kids.png" layer wallpaper atlas hdres }
                { img "res-4a-left.png" layer foreground atlas hddecos }
                { img "res-4a-left.png" dy 150 layer foreground atlas hddecos }
                { img "res-4a-props.png" dx 345 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 450 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 600 layer grime atlas hdgrime }
                { img "grime-4a.png" dy 150 layer grime atlas hdgrime }
                { img "grime-4b.png" dy 150 dx 200 layer grime atlas hdgrime hflip #true }
                { img "grime-1a.png" dy 150 dx 400 layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dy 150 dx 450 layer grime atlas hdgrime hflip #true }
                { img "grime-3b.png" dy 150 dx 600 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "zoned-left-second-res.png" layer foreground atlas hddecos }
                { img "middlefloor-15w.png" dy 146 layer worker atlas hdwalls }
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-door-second-res.png" dy 141.5 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 350 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 550 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 650 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 150 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 250 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 350 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 450 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 550 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 550 layer wallpaper atlas hdwalls }
                { img "uc-crate-chair.png" dx 51 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 144 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 213 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 250 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 304 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 363 layer deco atlas hddecos }
                { img "uc-toolbox.png" dx 459 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 500 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 595 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 635 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 667 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dy 150 dx 76 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dy 150 dx 171 layer deco atlas hddecos }
                { img "uc-box-4.png" dy 150 dx 235 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dy 150 dx 275 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dy 150 dx 335 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dy 150 dx 504 layer deco atlas hddecos }
                { img "uc-box-3.png" dy 150 dx 550 layer deco atlas hddecos }
                { img "uc-crate-short.png" dy 150 dx 595 layer deco atlas hddecos }
                { img "uc-trash-open.png" dy 150 dx 687 layer deco atlas hddecos }
            ]
            serviceanchors [
                { dx 50 tasktype servicedogs }
                { dx 50 tasktype servicegym }
                { dx 190 tasktype servicedecorator }
                { dx 50 dy 150 tasktype servicedrycleaning }
                { dx 50 dy 150 tasktype servicetailor }
                { dx 50 dy 150 tasktype servicedaycare }
                { dx 470 plusorminus 60 tasktype servicecleaning }
            ]
            residentanchors [
                { dx 199 dy 150 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" adultonly #true }
                { dx 330 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" adultonly #true }
                { dx 675 animm "res-stand-back-m" animf "res-stand-back-f" adultonly #true }
                { dx 376 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" adultonly #true }
                { dx 470 dy 150 animm "sleep-a-m" animf "sleep-a-f" sleep #true adultonly #true }
                { dx 497 dy 150 animm "sleep-a-m" animf "sleep-a-f" sleep #true adultonly #true }
                { dx 676 dy 150 animm "sleep-a-m" animf "sleep-a-f" sleep #true childonly #true }
                { dx 615 dy 150 animm "play-m" animf "play-f" childonly #true }
            ]
        }
        residence-level-four-b {
            open [
                { img "res-4b.png" layer wallpaper atlas hdres }
                { img "res-4a-left.png" layer foreground atlas hddecos }
                { img "res-4a-left.png" dy 150 layer foreground atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 450 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 600 layer grime atlas hdgrime }
                { img "grime-4a.png" dy 150 layer grime atlas hdgrime }
                { img "grime-4b.png" dy 150 dx 200 layer grime atlas hdgrime hflip #true }
                { img "grime-1a.png" dy 150 dx 400 layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dy 150 dx 450 layer grime atlas hdgrime hflip #true }
                { img "grime-3b.png" dy 150 dx 600 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "zoned-left-second-res.png" layer foreground atlas hddecos }
                { img "middlefloor-15w.png" dy 146 layer worker atlas hdwalls }
                { img "uc-res-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-door-second-res.png" dy 141.5 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 350 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 550 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 650 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 150 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 250 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 350 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 450 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 550 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dy 150 dx 550 layer wallpaper atlas hdwalls }
                { img "uc-crate-chair.png" dx 51 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 144 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 213 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 250 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 304 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 363 layer deco atlas hddecos }
                { img "uc-toolbox.png" dx 459 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 500 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 595 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 635 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 667 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dy 150 dx 76 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dy 150 dx 171 layer deco atlas hddecos }
                { img "uc-box-4.png" dy 150 dx 235 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dy 150 dx 275 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dy 150 dx 335 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dy 150 dx 504 layer deco atlas hddecos }
                { img "uc-box-3.png" dy 150 dx 550 layer deco atlas hddecos }
                { img "uc-crate-short.png" dy 150 dx 595 layer deco atlas hddecos }
                { img "uc-trash-open.png" dy 150 dx 687 layer deco atlas hddecos }
            ]
            residentanchors [
                { dx 427 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
                { dx 476 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
                { dx 358 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 623 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 199 dy 150 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 435 dy 150 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 518 dy 150 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
            ]
            serviceanchors [
                { dx 656 plusorminus 25 tasktype servicecleaning }
                { dx 50 tasktype servicedrycleaning }
                { dx 50 dy 150 tasktype serviceflowers }
                { dx 50 tasktype servicetailor }
                { dx 50 dy 150 tasktype servicedogdaycare }
                { dx 363 tasktype serviceyoga }
                { dx 189 tasktype servicedecorator }
                { dx 304 dy 150 tasktype servicefinance }
            ]
        }
        residence-penthouse-medium-left {
            open [
                { img "roof-railing-left.png" dx 0 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 50 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 100 layer foreground atlas hdwalls }
                { img "roof-railing-right.png" dx 150 layer foreground atlas hdwalls }
                { img "res-p-medium-left.png" dx 50 layer wallpaper atlas hdres }
                { img "res-p-medium-left.png" dx 200 layer foreground atlas hddecos }
                { img "patio-table.png" dx 89.5 layer deco atlas hddecos }
                { img "res-p-medium-chair.png" dx 234.5 layer deco atlas hddecos }
                { img "res-p-medium-props.png" dx 297 layer deco atlas hddecos }
                
                { img "grime-3a.png" dx 200 layer grime atlas hdgrime }
                { img "grime-2b.png" dx 350 layer grime atlas hdgrime }
                { img "grime-1b.png" dx 450 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 500 layer grime atlas hdgrime }
            ]
            construction [
                { img "zoned-res-door.png" dx 200 layer wallpaper atlas hdwalls  }
                { img "zoned-res-left.png" dx 200 layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 39 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 229 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 289 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 357 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 391 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 441 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 536 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 596 layer deco atlas hddecos }
                { img "uc-light.png" dx 648 layer deco atlas hddecos }
                { img "roof-railing-left.png" dx 0 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 50 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 100 layer foreground atlas hdwalls }
                { img "roof-railing-right.png" dx 150 layer foreground atlas hdwalls }
            ]
            residentanchors [
                { dx 568 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
                { dx 610 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
                { dx 90 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" }
                { dx 154 animm "res-sit-relax-l-m" animf "res-sit-relax-l-f" }
                { dx 268 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" }
                { dx 330 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 366 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
            ]
            serviceanchors [
                { dx 290 plusorminus 10 tasktype servicehandyman }
                { dx 440 plusorminus 10 tasktype servicelaundry }
                { dx 440 plusorminus 200 tasktype servicecleaning }
                { dx 440 plusorminus 10 tasktype servicedrycleaning }
                { dx 440 plusorminus 10 tasktype servicetailor }
                { dx 189 plusorminus 10 tasktype servicedogdaycare }
                { dx 350 plusorminus 50 tasktype servicegym }
            ]
        }
        residence-penthouse-lux-left {
            open [
                { img "res-p-lux-left.png" layer wallpaper atlas hdtwofloors }
                { img "roof-railing-left.png" dx 0 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 50 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 100 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 150 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 200 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 250 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 300 layer foreground atlas hdwalls }
                { img "roof-railing-right.png" dx 350 layer foreground atlas hdwalls }
                { img "bubbles.png" dx 55 dy 76 layer worker atlas hddecos framecount 5 fps 4.5 }
                { img "patio-table.png" dx 280 layer deco atlas hddecos }
                { img "res-p-lux-left.png" dx 400 layer foreground atlas hddecos }
                { img "chair-home-2.png" dx 569 layer deco atlas hddecos }
                { img "grime-4a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-2b.png" dx 600 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 700 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 850 layer grime atlas hdgrime }
            ]
            construction [
                { img "zoned-res-door.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-res-left.png" dx 400 layer foreground atlas hddecos }
                { img "uc-res-1w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 800 layer wallpaper atlas hdwalls }
                { img "uc-res-2w.png" dx 900 layer wallpaper atlas hdwalls }
                { img "uc-pallet-planks.png" dx 41 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 147 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 192 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 458 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 510 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 545 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-tv.png" dx 627 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 636 dy 38 layer deco atlas hddecos } 
                { img "uc-ladder.png" dx 712 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 798 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 868 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 912 dy 58.5 layer deco atlas hddecos }{ img "roof-railing-left.png" dx 0 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 50 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 100 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 150 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 200 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 250 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 300 layer foreground atlas hdwalls }
                { img "roof-railing-right.png" dx 350 layer foreground atlas hdwalls }
            ]
            residentanchors [
                { dx 880 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
                { dx 914 animm "sleep-a-m" animf "sleep-a-f" sleep #true }
                { dx 270 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" }
                { dx 347 animm "res-sit-relax-l-m" animf "res-sit-relax-l-f" }
                { dx 494 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
                { dx 587 animm "res-sit-relax-l-m" animf "res-sit-relax-l-f" }
                { dx 215 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 704 animm "res-stand-back-m" animf "res-stand-back-f" }
            ]
            serviceanchors [
                { dx 90 plusorminus 20 tasktype servicehandyman }
                { dx 965 plusorminus 5 tasktype servicedrycleaning }
                { dx 650 plusorminus 150 tasktype servicecleaning }
                { dx 458 plusorminus 5 tasktype serviceflowers }
                { dx 458 plusorminus 5 }
            ]
        }




    	;; -------------------------------------------------------------------

    	;; services

    	service-level-one-courier {
    		open [
                { img "service-o-1-courier.png" layer wallpaper atlas hdservices }
				{ img "service-1-cashier.png" dx 30 layer deco atlas hddecos }
				{ img "service-left-1.png" layer foreground atlas hddecos }
                { img "grime-1a.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 50 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-shovel.png" dx 39 layer deco atlas hddecos } 
                { img "uc-pallet-concrete.png" dx 52 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 125 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 160 layer deco atlas hddecos }
                { img "uc-light.png" dx 199 layer deco atlas hddecos }
             ]
            workstations [ { dx 60 anim peepworkf } { dx 100 anim peepworkb } { dx 144 anim peepworkf } { dx 210 anim peepworkb } ]

    	}

    	service-level-one-cleaning {
    		open [
                { img "service-o-1-cleaners.png" layer wallpaper atlas hdservices }
                { img "service-left-1.png" layer foreground atlas hddecos }
                { img "service-1-cashier-pc.png" dx 27 layer deco atlas hddecos }
                { img "grime-1b.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 50 layer grime atlas hdgrime }
            ]
    		construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-shovel.png" dx 39 layer deco atlas hddecos } 
                { img "uc-pallet-concrete.png" dx 52 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 125 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 160 layer deco atlas hddecos }
                { img "uc-light.png" dx 199 layer deco atlas hddecos }
             ]
             workstations [ { dx 41 anim peepworkf } { dx 100 anim peepworkf } { dx 149 anim peepworkf } { dx 188 anim peepworkf } ]
    	}

    	service-level-one-supplies {
    		open [
                { img "service-o-1-supplies.png" layer wallpaper atlas hdservices }
				{ img "service-1-cashier.png" dx 30 layer deco atlas hddecos }
				{ img "service-left-2.png" layer foreground atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 100 layer grime atlas hdgrime }
            ]
    		construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-shovel.png" dx 39 layer deco atlas hddecos } 
                { img "uc-pallet-concrete.png" dx 52 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 125 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 160 layer deco atlas hddecos }
                { img "uc-light.png" dx 199 layer deco atlas hddecos }
             ]
            workstations [ { dx 60 anim peepworkf } { dx 100 anim peepworkb } { dx 144 anim peepworkf } { dx 210 anim peepworkb } ]

    	}

    	service-level-one-water {
    		open [
                { img "service-o-1-water.png" layer wallpaper atlas hdservices }
                { img "service-left-1.png" layer foreground atlas hddecos }
                { img "service-1-cashier-pc.png" dx 27 layer deco atlas hddecos }
                { img "grime-2b.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 100 layer grime atlas hdgrime }
            ]
    		construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-shovel.png" dx 39 layer deco atlas hddecos } 
                { img "uc-pallet-concrete.png" dx 52 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 125 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 160 layer deco atlas hddecos }
                { img "uc-light.png" dx 199 layer deco atlas hddecos }
             ]
             workstations [ { dx 60 anim peepworkf } { dx 100 anim peepworkb } { dx 144 anim peepworkf } { dx 210 anim peepworkb } ]
    	}

    	service-level-one-copies {
    		open [
                { img "service-o-1-copies.png" layer wallpaper atlas hdservices }
				{ img "service-1-cashier.png" dx 30 layer deco atlas hddecos }
				{ img "service-left-2.png" layer foreground atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dx 100 layer grime atlas hdgrime hflip #true }
            ]
    		construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-shovel.png" dx 39 layer deco atlas hddecos } 
                { img "uc-pallet-concrete.png" dx 52 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 125 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 160 layer deco atlas hddecos }
                { img "uc-light.png" dx 199 layer deco atlas hddecos }
             ]
            workstations [ { dx 60 anim peepworkf } { dx 100 anim peepworkb } { dx 210 anim peepworkf } { dx 175 anim peepworkb } ]
    	}

		service-level-two-computers {
			open [
                { img "service-o-2-computers.png" layer wallpaper atlas hdservices }
                { img "service-2-cashier-1.png" dx 33 layer deco atlas hddecos }
                { img "stool-1.png" dx 154 layer deco atlas hddecos }
                { img "service-left-1.png" layer foreground atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 300 layer grime atlas hdgrime }
                { img "grime-2a.png" dx 350 layer grime atlas hdgrime }
             ]
			construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 250 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 350 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 22 layer deco atlas hddecos }
                { img "uc-light.png" dx 104 layer deco atlas hddecos hflip #true }
                { img "uc-concrete-sacks.png" dx 163 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 210 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 244 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 275 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 335 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 385 layer deco atlas hddecos }
            ]
            workstations [ { dx 70 anim peepworkf }  { dx 166 anim peepworkb } { dx 233 anim peepworkb } { dx 316 anim peepworkf } { dx 419 anim peepworkb } ]
		}

		service-level-two-catering {
			open [
                { img "service-o-2-catering.png" layer wallpaper atlas hdservices }
                { img "service-left-2.png" layer foreground atlas hddecos }
                { img "service-2-cashier-1.png" dx 33 layer deco atlas hddecos }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 150 layer grime atlas hdgrime }
                { img "grime-1b.png" dx 300 layer grime atlas hdgrime }
                { img "grime-2b.png" dx 350 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 250 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 350 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 22 layer deco atlas hddecos }
                { img "uc-light.png" dx 104 layer deco atlas hddecos hflip #true }
                { img "uc-concrete-sacks.png" dx 163 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 210 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 244 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 275 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 335 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 385 layer deco atlas hddecos }
            ]
            workstations [ { dx 72 anim peepworkf } { dx 154 anim peepworkb } { dx 200 anim peepworkb } { dx 237 anim peepworkb } { dx 288 anim peepworkb } ]
		}

		service-level-two-printer {
			open [
                { img "service-o-2-printing.png" layer wallpaper atlas hdservices }
                { img "service-left-2.png" layer foreground atlas hddecos }
                { img "service-2-cashier-1.png" dx 33 layer deco atlas hddecos }
                { img "service-2-copier.png" dx 104 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime hflip #true }
                { img "grime-1a.png" dx 300 layer grime atlas hdgrime hflip #true }
                { img "grime-2a.png" dx 350 layer grime atlas hdgrime hflip #true }
            ]
			construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 250 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 350 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 22 layer deco atlas hddecos }
                { img "uc-light.png" dx 104 layer deco atlas hddecos hflip #true }
                { img "uc-concrete-sacks.png" dx 163 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 210 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 244 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 275 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 335 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 385 layer deco atlas hddecos }
            ]
            workstations [ { dx 65 anim peepworkf } { dx 143 anim peepworkf } { dx 218 anim peepworkb } { dx 340 anim peepworkb } { dx 410 anim peepworkf } ]
		}

		service-level-two-storage {
			open [
                { img "service-o-2-storage.png" layer wallpaper atlas hdservices }
                { img "service-left-1.png" layer foreground atlas hddecos }
                { img "service-2-cashier-1.png" dx 33 layer deco atlas hddecos }
                { img "grime-1.png" layer grime atlas hdgrime }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 150 layer grime atlas hdgrime hflip #true }
                { img "grime-1b.png" dx 300 layer grime atlas hdgrime hflip #true }
                { img "grime-2b.png" dx 350 layer grime atlas hdgrime hflip #true }
            ]
			construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 250 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 350 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 22 layer deco atlas hddecos }
                { img "uc-light.png" dx 104 layer deco atlas hddecos hflip #true }
                { img "uc-concrete-sacks.png" dx 163 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 210 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 244 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 275 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 335 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 385 layer deco atlas hddecos }
            ]
            workstations [ { dx 63 anim peepworkf } { dx 150 anim peepworkf } { dx 215 anim peepworkf } { dx 335 anim peepworkf } { dx 418 anim peepworkf } ]
		}
        service-level-three-consultants {
            open [
                { img "service-o-3-consultants.png" layer wallpaper atlas hdservices }
                { img "service-3-left.png" layer foreground atlas hddecos }
                { img "service-o-3-consultants-props-left.png" dx 53 layer deco atlas hddecos }
                { img "chair-desk-12.png" dx 155 layer deco atlas hddecos }
                { img "chair-desk-15.png" dx 396 layer deco atlas hddecos }
                { img "chair-desk-15.png" dx 512 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime }
                { img "grime-2a.png" dx 500 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 500 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 404 layer deco atlas hddecos }
                { img "uc-light.png" dx 430 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 511 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 573 dy 36 layer deco atlas hddecos }
            ]
            workstations [ { dx 128 anim peepworkf } { dx 288 anim peepworkl } { dx 414 anim peepworkb }  { dx 530 anim peepworkb } ]
        }
        service-level-three-tempagency {
            open [
                { img "service-o-3-tempagency.png" layer wallpaper atlas hdservices }
                { img "service-3-left.png" layer foreground atlas hddecos }
                { img "service-o-3-consultants-props-left.png" dx 53 layer deco atlas hddecos }
                { img "chair-desk-12.png" dx 155 layer deco atlas hddecos }
                { img "chair-desk-15.png" dx 242 layer deco atlas hddecos }
                { img "chair-desk-15.png" dx 306 layer deco atlas hddecos }
                { img "chair-desk-15.png" dx 369 layer deco atlas hddecos }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 150 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 300 layer grime atlas hdgrime }
                { img "grime-2b.png" dx 500 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 500 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 404 layer deco atlas hddecos }
                { img "uc-light.png" dx 430 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 511 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 573 dy 36 layer deco atlas hddecos }
            ]
            workstations [ { dx 161 anim peepworkl } { dx 259 anim peepworkb } { dx 386 anim peepworkb } { dx 488 anim peepworkl } ]
        }
        service-level-three-fitness {
            open [
                { img "service-o-3-fitness.png" layer wallpaper atlas hdservices }
                { img "service-3e-left.png" layer foreground atlas hddecos }
                { img "chair-desk-8.png" dx 115 layer deco atlas hddecos }
                { img "service-o-3-fitness-props.png" dx 472 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime hflip #true }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime hflip #true }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime hflip #true }
                { img "grime-2a.png" dx 500 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 500 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 404 layer deco atlas hddecos }
                { img "uc-light.png" dx 430 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 511 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 573 dy 36 layer deco atlas hddecos }
            ]
            workstations [ { dx 101 anim peepworkl } { dx 206 anim peepworkf } { dx 516 anim peepworkf } ]
        }
        service-level-three-security {
            open [
                { img "service-o-3-security.png" layer wallpaper atlas hdservices }
                { img "service-3d-left.png" layer foreground atlas hddecos }
                { img "service-o-3-security-props.png" dx 113 layer deco atlas hddecos }
                { img "service-o-security-props-right.png" dx 488 layer deco atlas hddecos }
                { img "chair-desk-8.png" dx 284 layer deco atlas hddecos }
                { img "chair-desk-8.png" dx 380 layer deco atlas hddecos }
                { img "grime-3b.png" layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dx 150 layer grime atlas hdgrime hflip #true }
                { img "grime-4b.png" dx 300 layer grime atlas hdgrime hflip #true }
                { img "grime-2b.png" dx 500 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 500 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 404 layer deco atlas hddecos }
                { img "uc-light.png" dx 430 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 511 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 573 dy 36 layer deco atlas hddecos }
            ]
            workstations [ { dx 155 anim peepworkf } { dx 290 anim peepworkl } { dx 384 anim peepworkl } { dx 513 anim peepworkb } ]
        }
        service-level-three-design {
            open [
                { img "service-o-3-design.png" layer wallpaper atlas hdservices }
                { img "service-3c-left.png" layer foreground atlas hddecos }
                { img "service-o-3-design-props.png" dx 60 layer deco atlas hddecos }
                { img "chair-desk-13.png" dx 159 layer deco atlas hddecos }
                { img "chair-desk-14.png" dx 239 layer deco atlas hddecos }
                { img "chair-desk-14.png" dx 311 layer deco atlas hddecos }
                { img "chair-desk-13.png" dx 554 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime hflip #true }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime hflip #true }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime hflip #true }
                { img "grime-2a.png" dx 500 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 500 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 404 layer deco atlas hddecos }
                { img "uc-light.png" dx 430 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 511 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 573 dy 36 layer deco atlas hddecos }
            ]
            workstations [ { dx 100 anim peepworkf } { dx 254 anim peepworkb } { dx 329 anim peepworkb } { dx 563 anim peepworkl } ]
        }

        service-four-club {
            open [
                { img "service-o-4-a.png" layer wallpaper atlas hdservices }
                { img "service-4a-left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
            ]
            workstations [ { dx 175 anim peepworkf } ]
            serviceanchors [ { dx 225 } ]
        }
        service-four-helicopter {
            open [
                { img "service-o-4-b.png" layer wallpaper atlas hdservices }
                { img "service-4b-left.png" layer foreground atlas hddecos }
                { img "service-o-4-b-props.png" dx 31 layer deco atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
            ]
            workstations [ { dx 68 anim peepworkf } { dx 325 anim peepworkf } ]
        }
        service-four-limo {
            open [
                { img "service-o-4-c.png" layer wallpaper atlas hdservices }
                { img "service-4c-left.png" layer foreground atlas hddecos }
                { img "service-o-4-c-props.png" dx 31 layer deco atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
            ]
            workstations [ { dx 68 anim peepworkf } { dx 350 anim peepworkf } ]
        }


		
        ;; -------------------------------------------------------------------

        ;; residential services

        service-residential-one-handyman {
            open [ 
                { img "service-r-handy.png" layer wallpaper atlas hdservices }
                { img "service-r-left-3.png" layer foreground atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 100 layer grime atlas hdgrime }
             ]
             construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-shovel.png" dx 39 layer deco atlas hddecos } 
                { img "uc-pallet-concrete.png" dx 52 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 125 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 160 layer deco atlas hddecos }
                { img "uc-light.png" dx 199 layer deco atlas hddecos }
             ]
             workstations [ { dx 57 anim peepworkb } { dx 103 anim peepworkb } { dx 169 anim peepworkf } { dx 202 anim peepworkf} ]
        }
        service-residential-one-plumber {
            open [ 
                { img "service-r-plumber.png" layer wallpaper atlas hdservices }
                { img "service-r-left-3.png" layer foreground atlas hddecos }
                { img "grime-2b.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 100 layer grime atlas hdgrime }
             ]
             construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-shovel.png" dx 39 layer deco atlas hddecos } 
                { img "uc-pallet-concrete.png" dx 52 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 125 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 160 layer deco atlas hddecos }
                { img "uc-light.png" dx 199 layer deco atlas hddecos }
             ]
             workstations [ { dx 52 anim peepworkf } { dx 100 anim peepworkb } { dx 139 anim peepworkf } { dx 202 anim peepworkb } ]
        }
        service-residential-one-laundry {
            open [ 
                { img "service-r-laundry.png" layer wallpaper atlas hdservices }
                { img "service-r-laundry-props.png" dx 34 layer deco atlas hddecos }
                { img "service-r-left-4.png" layer foreground atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dx 100 layer grime atlas hdgrime hflip #true }
             ]
             construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-shovel.png" dx 39 layer deco atlas hddecos } 
                { img "uc-pallet-concrete.png" dx 52 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 125 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 160 layer deco atlas hddecos }
                { img "uc-light.png" dx 199 layer deco atlas hddecos }
             ]
             workstations [ { dx 60 anim peepworkf } { dx 117 anim peepworkf } { dx 167 anim peepworkb } { dx 220 anim peepworkb } ]
        }
        service-residential-two-dogs {
            open [
                { img "service-r-dogs.png" layer wallpaper atlas hdservices }
                { img "service-r-left-3.png" layer foreground atlas hddecos }
                { img "service-r-dogs-props-left.png" dx 30 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 300 layer grime atlas hdgrime }
                { img "grime-2a.png" dx 350 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 250 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 350 dy 110 layer wallpaper atlas hdwalls } 
                { img "uc-pallet-concrete.png" dx 22 layer deco atlas hddecos }
                { img "uc-light.png" dx 104 layer deco atlas hddecos hflip #true }
                { img "uc-concrete-sacks.png" dx 163 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 210 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 244 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 275 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 335 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 385 layer deco atlas hddecos }
            ]
            workstations [ { dx 120 anim peepworkf} { dx 200 anim peepworkb } { dx 285 anim peepworkb } { dx 365 anim peepworkb } ]
        }
        service-residential-two-cleaners {
            open [
                { img "service-r-cleaning.png" layer wallpaper atlas hdservices }
                { img "service-r-left-3.png" layer foreground atlas hddecos }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 150 layer grime atlas hdgrime }
                { img "grime-1b.png" dx 300 layer grime atlas hdgrime }
                { img "grime-2b.png" dx 350 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 250 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 350 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 22 layer deco atlas hddecos }
                { img "uc-light.png" dx 104 layer deco atlas hddecos hflip #true }
                { img "uc-concrete-sacks.png" dx 163 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 210 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 244 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 275 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 335 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 385 layer deco atlas hddecos }
            ]
            workstations [ { dx 87 anim peepworkf } { dx 177 anim peepworkb } { dx 294 anim peepworkb } { dx 398 anim peepworkb } ]
        }
        service-residential-three-tailor {
            open [
                { img "service-r-tailor.png" layer wallpaper atlas hdservices }
                { img "service-r-left-1.png" layer foreground atlas hddecos }
                { img "service-r-tailor-props.png" dx 30 layer deco atlas hddecos }
                { img "chair-desk-11.png" dx 486 layer deco atlas hddecos }
                { img "chair-desk-11.png" dx 535 layer deco atlas hddecos }
                { img "grime-2.png" layer grime atlas hdgrime }
                { img "grime-2.png" dx 100 layer grime atlas hdgrime }
                { img "grime-2.png" dx 200 layer grime atlas hdgrime }
                { img "grime-2.png" dx 300 layer grime atlas hdgrime }
                { img "grime-2.png" dx 400 layer grime atlas hdgrime }
                { img "grime-2.png" dx 500 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 500 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 404 layer deco atlas hddecos }
                { img "uc-light.png" dx 430 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 511 layer deco atlas hddecos }
            ]
            workstations [ { dx 75 anim peepworkf } { dx 388 anim peepworkb } ]
        }
        service-r-three-drycleaning {
            open [
                { img "service-r-drycleaning.png" layer wallpaper atlas hdservices }
                { img "service-r-drycleaning-props.png" dx 33 layer deco atlas hddecos }
                { img "service-r-left-1.png" layer foreground atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 100 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 250 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 500 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 404 layer deco atlas hddecos }
                { img "uc-light.png" dx 430 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 511 layer deco atlas hddecos }
            ]
            workstations [ { dx 69 anim peepworkf } { dx 500 anim peepworkb } ]
        }
        service-r-three-floral {
            open [
                { img "service-r-flowers.png" layer wallpaper atlas hdservices }
                { img "service-r-left-1.png" layer foreground atlas hddecos }
                { img "service-r-flowers-props-left.png" dx 30 layer deco atlas hddecos }
                { img "service-r-flowers-center.png" dx 357 layer deco atlas hddecos }
                { img "chair-desk-9.png" dx 530 layer deco atlas hddecos }
                { img "grime-2b.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 100 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 250 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 500 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 404 layer deco atlas hddecos }
                { img "uc-light.png" dx 430 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 511 layer deco atlas hddecos }
            ]
            workstations [ { dx 65 anim peepworkf } { dx 450 anim peepworkf } { dx 547 anim peepworkb } ]
        }
        service-r-three-dogdaycare {
            open [
                { img "service-r-dogdaycare.png" layer wallpaper atlas hdservices }
                { img "service-r-left-2.png" layer foreground atlas hddecos }
                { img "service-r-dogdaycare-props.png" dx 31 layer wallpaper atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dx 100 layer grime atlas hdgrime hflip #true }
                { img "grime-4a.png" dx 250 layer grime atlas hdgrime hflip #true }
                { img "grime-3b.png" dx 450 layer grime atlas hdgrime hflip #true }
            ]
            construction [
               { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 500 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 404 layer deco atlas hddecos }
                { img "uc-light.png" dx 430 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 511 layer deco atlas hddecos }
            ]
            workstations [ { dx 66 anim peepworkf } { dx 214 anim peepworkb } { dx 400 anim peepworkf }  { dx 571 anim peepworkb } ]
        }
        service-r-three-daycare {
            open [
                { img "service-r-daycare.png" layer wallpaper atlas hdservices }
                { img "service-r-left-3.png" layer foreground atlas hddecos }
                { img "service-r-daycare-props.png" dx 30 layer deco atlas hddecos }
                { img "chair-home-1.png" dx 236 layer deco atlas hddecos }
                { img "grime-2b.png" layer grime atlas hdgrime hflip #true }
                { img "grime-3b.png" dx 100 layer grime atlas hdgrime hflip #true }
                { img "grime-4b.png" dx 250 layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dx 450 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 500 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 404 layer deco atlas hddecos }
                { img "uc-light.png" dx 430 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 511 layer deco atlas hddecos }
            ]
            workstations [ { dx 66 anim peepworkf } { dx 211 anim peepworkf } { dx 400 anim peepworkf }  { dx 415 anim peepworkf } ]
        }
        service-r-three-gym {
            open [
                { img "service-r-gym.png" layer wallpaper atlas hdservices }
                { img "service-r-left-4.png" layer foreground atlas hddecos }
                { img "service-r-gym-props.png" dx 33 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-2a.png" dx 100 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 250 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 500 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-pallet-concrete.png" dx 38 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 layer deco atlas hddecos }
                { img "uc-light.png" dx 156 layer deco atlas hddecos hflip #true }
                { img "uc-buckets-paint.png" dx 204 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 239 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 363 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 404 layer deco atlas hddecos }
                { img "uc-light.png" dx 430 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 511 layer deco atlas hddecos }
            ]
            workstations [  { dx 75 anim peepworkf } { dx 200 anim peepworkb } { dx 400 anim peepworkf } { dx 550 anim peepworkb } ]
        }
        service-r-four-trainer {
            open [
                { img "service-r-trainer.png" layer wallpaper atlas hdservices }
                { img "service-r-4-left.png" layer foreground atlas hddecos }
                { img "service-r-trainer-props.png" dx 33 layer deco atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 51 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 104 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 141 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 185 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 294 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 340 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 387 layer deco atlas hddecos  }
                { img "uc-light.png" dx 445 layer deco atlas hddecos }
            ]
            workstations [ { dx 80 anim peepworkf } { dx 172 anim peepworkf } { dx 260 anim peepworkb } { dx 466 anim peepworkf } ]
        }
        service-r-four-yoga {
            open [
                { img "service-r-yoga.png" layer wallpaper atlas hdservices }
                { img "service-r-4-left.png" layer foreground atlas hddecos }
                { img "service-r-yoga-props.png" dx 33 layer deco atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 51 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 104 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 141 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 185 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 294 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 340 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 387 layer deco atlas hddecos  }
                { img "uc-light.png" dx 445 layer deco atlas hddecos }
            ]
            workstations [ { dx 80 anim peepworkf } { dx 260 anim peepworkf } { dx 373 anim peepworkb } { dx 466 anim peepworkb } ]
        }
        service-r-four-decorator {
            open [
                { img "service-r-decorator.png" layer wallpaper atlas hdservices }
                { img "service-r-4-left.png" layer foreground atlas hddecos }
                { img "chair-desk-22.png" dx 216 layer deco atlas hddecos }
                { img "service-r-decorator-props.png" dx 405 layer deco atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 51 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 104 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 141 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 185 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 294 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 340 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 387 layer deco atlas hddecos  }
                { img "uc-light.png" dx 445 layer deco atlas hddecos }
            ]
            workstations [ { dx 85 anim peepworkf } { dx 139 anim peepworkf } { dx 311 anim peepworkb } { dx 448 anim peepworkf } ]
        }
        service-r-four-finance {
            open [
                { img "service-r-therapist.png" layer wallpaper atlas hdservices }
                { img "service-r-4-left.png" layer foreground atlas hddecos }
                { img "service-r-props-therapist.png" dx 30 layer deco atlas hddecos }
                { img "chair-desk-22.png" dx 444 layer deco atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 51 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 104 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 141 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 185 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 294 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 340 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 387 layer deco atlas hddecos  }
                { img "uc-light.png" dx 445 layer deco atlas hddecos }
            ]
            workstations [ { dx 67 anim peepworkf } { dx 192 anim peepworkf } { dx 250 anim peepworkf } { dx 448 anim peepworkl } ]
        }



        ;; -------------------------------------------------------------------

        ;; retail units

        retail-level-one-a {
            open [
                { img "retail-1a.png" layer wallpaper atlas hdcom }
                { img "service-1-left.png" layer foreground atlas hddecos }
                { img "retail-1a-props.png" dx 33 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 150 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 12 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 122 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 180 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 241 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 289 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 39 dy 50 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 77 dy 50 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 125 dy 58.5 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 149 dy 58.5 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 196 dy 116.5 layer deco atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 246 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 291 dy 64 layer deco atlas hddecos }
            ]
            workstations [ { dx 75 anim peepworkf } ]
            visitoranchors [ { dx 40 plusorminus 20 } { dx 157 plusorminus 20 } { dx 275 plusorminus 20 } ]
        }
        retail-level-one-b {
            open [
                { img "retail-1b.png" layer wallpaper atlas hdcom }
                { img "retail-1b-left.png" layer foreground atlas hddecos }
                { img "retail-1b-props.png" dx 31 layer deco atlas hddecos }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 150 layer grime atlas hdgrime }
             ]
             construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 12 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 122 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 180 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 241 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 289 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 39 dy 50 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 77 dy 50 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 125 dy 58.5 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 149 dy 58.5 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 196 dy 116.5 layer deco atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 246 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 291 dy 64 layer deco atlas hddecos }
            ]
            workstations [ { dx 75 anim peepworkf } { dx 150 anim peepworkf } ]
            visitoranchors [ { dx 36 plusorminus 20 } { dx 144 plusorminus 20 } { dx 257 plusorminus 20 } ]
        }
        retail-level-one-c {
            open [
                { img "retail-1c.png" layer wallpaper atlas hdcom }
                { img "service-1-left.png" layer foreground atlas hddecos }
                { img "retail-1c-props.png" dx 141 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 200 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 12 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 122 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 180 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 241 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 289 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 39 dy 50 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 77 dy 50 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 125 dy 58.5 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 149 dy 58.5 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 196 dy 116.5 layer deco atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 246 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 291 dy 64 layer deco atlas hddecos }
            ]
            workstations [ { dx 204 anim peepworkf } ]
            visitoranchors [ { dx 30 plusorminus 5 } { dx 86 plusorminus 5 } { dx 188 plusorminus 100 } ]
        }
        retail-level-one-d {
            open [
                { img "retail-1d.png" layer wallpaper atlas hdcom }
                { img "retail-1d-left.png" layer foreground atlas hddecos }
                { img "retail-1d-props.png" dx 33 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 12 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 122 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 180 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 241 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 289 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 39 dy 50 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 77 dy 50 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 125 dy 58.5 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 149 dy 58.5 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 196 dy 116.5 layer deco atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 246 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 291 dy 64 layer deco atlas hddecos }
            ]
            workstations [ { dx 95 anim peepworkf } { dx 200 anim peepworkf } ]
            visitoranchors [ { dx 102 plusorminus 70 } { dx 194 plusorminus 10 } ]
        }
        retail-level-one-e-bottle {
            open [
                { img "retail-1e-bottle.png" layer wallpaper atlas hdcom }
                { img "retail-1e-left.png" layer foreground atlas hddecos }
                { img "retail-1e-bottles-props.png" dx 27 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime hflip #true }
                { img "grime-4a.png" dx 150 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 12 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 122 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 180 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 241 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 289 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 39 dy 50 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 77 dy 50 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 125 dy 58.5 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 149 dy 58.5 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 196 dy 116.5 layer deco atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 246 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 291 dy 64 layer deco atlas hddecos }
            ]
            workstations [ { dx 59 anim peepworkf } ]
            visitoranchors [ { dx 45 plusorminus 20 } { dx 249 plusorminus 40 } ]
        }
        retail-level-one-e-flowers {
            open [
                { img "retail-1e-flowers.png" layer wallpaper atlas hdcom }
                { img "retail-1e-left.png" layer foreground atlas hddecos }
                { img "retail-1e-flowers-props.png" dx 31 layer deco atlas hddecos }
                { img "grime-3b.png" layer grime atlas hdgrime hflip #true }
                { img "grime-4b.png" dx 150 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 12 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 122 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 180 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 241 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 289 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 39 dy 50 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 77 dy 50 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 125 dy 58.5 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 149 dy 58.5 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 196 dy 116.5 layer deco atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 246 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 291 dy 64 layer deco atlas hddecos }
            ]
            workstations [ { dx 65 anim peepworkf } ]
            visitoranchors [ { dx 50 plusorminus 30 } { dx 157 plusorminus 30 } ]
        }
        retail-level-two-a {
            open [
                { img "retail-2a.png" layer wallpaper atlas hdcom }
                { img "retail-2a-left.png" layer foreground atlas hddecos }
                { img "retail-2a-props.png" dx 30 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 35 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 106 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 215 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 279 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 346 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 397 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 443 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 545 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 139 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 229 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 353 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 450 dy 48 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 486 dy 48 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 551 dy 93.5 layer deco atlas hddecos }
            ]
            workstations [ { dx 57 anim peepworkf } ]
            visitoranchors [ { dx 45 plusorminus 20 } { dx 327 plusorminus 40 } ]
        }
        retail-level-two-b {
            open [
                { img "retail-2b.png" layer wallpaper atlas hdcom }
                { img "retail-2a-left.png" layer foreground atlas hddecos }
                { img "retail-2b-props-left.png" dx 36 layer deco atlas hddecos }
                { img "retail-2b-props-center.png" dx 286 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime }
                { img "grime-1b.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 35 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 106 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 215 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 279 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 346 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 397 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 443 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 545 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 139 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 229 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 353 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 450 dy 48 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 486 dy 48 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 551 dy 93.5 layer deco atlas hddecos }
            ]
            workstations [ { dx 98 anim peepworkf } { dx 298 anim peepworkf } ]
            visitoranchors [ { dx 91 plusorminus 60 } { dx 341 plusorminus 60 }  ]
        }
        retail-level-two-c-shoes {
            open [
                { img "retail-2c-shoes.png" layer wallpaper atlas hdcom }
                { img "retail-2c-left.png" layer foreground atlas hddecos }
                { img "retail-2c-shoes-props.png" dx 225 layer deco atlas hddecos }
                { img "grime-1a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 35 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 106 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 215 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 279 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 346 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 397 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 443 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 545 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 139 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 229 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 353 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 450 dy 48 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 486 dy 48 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 551 dy 93.5 layer deco atlas hddecos }
            ]
            workstations [ { dx 262 anim peepworkf } ]
            visitoranchors [ { dx 110 plusorminus 60 } { dx 221 plusorminus 40 } { dx 460 plusorminus 60 } ]
        }
        retail-level-two-c-purses {
            open [
                { img "retail-2c-purses.png" layer wallpaper atlas hdcom }
                { img "retail-2c-left.png" layer foreground atlas hddecos }
                { img "retail-2c-purses-props.png" dx 208 layer deco atlas hddecos }
                { img "grime-1b.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 200 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 400 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 35 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 106 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 215 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 279 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 346 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 397 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 443 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 545 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 139 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 229 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 353 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 450 dy 48 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 486 dy 48 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 551 dy 93.5 layer deco atlas hddecos }
            ]
            workstations [ { dx 250 anim peepworkf } ]
            visitoranchors [ { dx 110 plusorminus 60 } { dx 221 plusorminus 40 } { dx 480 plusorminus 60 } ]
        }
        retail-level-two-d {
            open [
                { img "retail-2d.png" layer wallpaper atlas hdcom }
                { img "retail-2d-left.png" layer foreground atlas hddecos }
                { img "retail-2d-props.png" dx 121 layer deco atlas hddecos }
                { img "grime-1a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 50 layer grime atlas hdgrime hflip #true }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime hflip #true }
                { img "grime-4a.png" dx 400 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 35 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 106 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 215 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 279 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 346 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 397 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 443 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 545 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 139 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 229 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 353 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 450 dy 48 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 486 dy 48 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 551 dy 93.5 layer deco atlas hddecos }
            ]
            workstations [ { dx 158 anim peepworkf } ]
            visitoranchors [ { dx 140 plusorminus 20 } { dx 413 plusorminus 60 } ]
        }

        retail-level-three-a {
            open [
                { img "retail-3a.png" layer wallpaper atlas hdtwofloors }
                { img "retail-3a-left.png" layer foreground atlas hddecos }
                { img "retail-3a-props-top.png" dx 324 dy 159 layer deco atlas hddecos }
                { img "retail-3a-props-bottom.png" dx 432 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 450 layer grime atlas hdgrime }
                { img "grime-3a.png" dy 150 layer grime atlas hdgrime }
                { img "grime-1b.png" dy 150 dx 200 layer grime atlas hdgrime }
                { img "grime-4a.png" dy 150 dx 400 layer grime atlas hdgrime }
                { img "grime-4b.png" dy 150 dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "middlefloor-12w.png" dy 146 layer worker atlas hdwalls }
                { img "zoned-left-second-retail.png" layer foreground atlas hddecos }
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "zoned-door-second-retail.png" dy 141.5 layer wallpaper atlas hdwalls }
                { img "uc-retail-1w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 500 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 35 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 106 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 215 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 279 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 346 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 397 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 443 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 545 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 139 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 229 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 353 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 450 dy 48 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 486 dy 48 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 551 dy 93.5 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 51 dy 150 layer deco atlas hddecos}
                { img "uc-crate-long.png" dx 119 dy 150 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 212 dy 150 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 182 dy 198 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 347 dy 150 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 386 dy 150 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 432 dy 150 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 475 dy 150 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 533 dy 150 layer deco atlas hddecos }
            ]
            workstations [ { dx 476 anim peepworkf } { dx 365 dy 150 anim peepworkf } ]
            visitoranchors [ { dx 310 plusorminus 50 } { dx 477 plusorminus 30 }  { dx 44 dy 150 plusorminus 20 } { dx 380 dy 150 plusorminus 60 } ]
        }
        retail-level-three-b {
            open [
                { img "retail-3b.png" layer wallpaper atlas hdtwofloors }
                { img "retail-3b-left.png" layer foreground atlas hddecos }
                { img "retail-3b-props-top.png" dx 35 dy 159 layer deco atlas hddecos }
                { img "retail-3b-props-bottom.png" dx 54 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime }
                { img "grime-1b.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 450 layer grime atlas hdgrime }
                { img "grime-3b.png" dy 150 layer grime atlas hdgrime }
                { img "grime-1a.png" dy 150 dx 200 layer grime atlas hdgrime }
                { img "grime-4b.png" dy 150 dx 400 layer grime atlas hdgrime }
                { img "grime-4a.png" dy 150 dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "middlefloor-12w.png" dy 146 layer worker atlas hdwalls }
                { img "zoned-left-second-retail.png" layer foreground atlas hddecos }
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "zoned-door-second-retail.png" dy 141.5 layer wallpaper atlas hdwalls }
                { img "uc-retail-1w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 500 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 35 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 106 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 215 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 279 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 346 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 397 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 443 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 545 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 139 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 229 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 353 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 450 dy 48 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 486 dy 48 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 551 dy 93.5 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 51 dy 150 layer deco atlas hddecos}
                { img "uc-crate-long.png" dx 119 dy 150 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 212 dy 150 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 182 dy 198 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 347 dy 150 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 386 dy 150 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 432 dy 150 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 475 dy 150 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 533 dy 150 layer deco atlas hddecos }
            ]
            workstations [ { dx 65 anim peepworkr } { dx 79 dy 150 anim peepworkf } ]
            visitoranchors [ { dx 105 plusorminus 10 } { dx 435 plusorminus 100 } { dx 60 dy 150 plusorminus 10 } { dx 355 dy 150 plusorminus 100 } ]
        }
        retail-level-three-c {
            open [
                { img "retail-3c.png" layer wallpaper atlas hdtwofloors }
                { img "retail-3c-left.png" layer foreground atlas hddecos }
                { img "retail-3c-props-left.png" dx 65 layer deco atlas hddecos }
                { img "retail-3c-props-right.png" dx 155 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime hflip #true }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime hflip #true }
                { img "grime-1b.png" dx 400 layer grime atlas hdgrime hflip #true }
                { img "grime-3b.png" dx 450 layer grime atlas hdgrime hflip #true }
                { img "grime-3b.png" dy 150 layer grime atlas hdgrime hflip #true }
                { img "grime-1a.png" dy 150 dx 200 layer grime atlas hdgrime hflip #true }
                { img "grime-4b.png" dy 150 dx 400 layer grime atlas hdgrime hflip #true }
                { img "grime-4a.png" dy 150 dx 450 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "middlefloor-12w.png" dy 146 layer worker atlas hdwalls }
                { img "zoned-left-second-retail.png" layer foreground atlas hddecos }
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "zoned-door-second-retail.png" dy 141.5 layer wallpaper atlas hdwalls }
                { img "uc-retail-1w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 500 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 35 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 106 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 215 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 279 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 346 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 397 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 443 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 545 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 139 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 229 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 353 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 450 dy 48 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 486 dy 48 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 551 dy 93.5 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 51 dy 150 layer deco atlas hddecos}
                { img "uc-crate-long.png" dx 119 dy 150 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 212 dy 150 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 182 dy 198 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 347 dy 150 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 386 dy 150 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 432 dy 150 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 475 dy 150 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 533 dy 150 layer deco atlas hddecos }
            ]
            workstations [ { dx 73 anim peepworkr } { dx 156 anim peepworkr } ]
            visitoranchors [ { dx 110 plusorminus 10 } { dx 196 plusorminus 10 } { dx 513 plusorminus 40 } { dx 111 dy 150 plusorminus 120 } ]
        }
        retail-level-three-d {
            open [
                { img "retail-3d.png" layer wallpaper atlas hdtwofloors }
                { img "retail-3d-left.png" layer foreground atlas hddecos }
                { img "retail-3d-props-bottom.png" dx 61 layer foreground atlas hddecos }
                { img "retail-3d-props-top-left.png" dx 109 dy 159 layer deco atlas hddecos }
                { img "retail-3d-props-top-right.png" dx 441 dy 159 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime hflip #true }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime hflip #true }
                { img "grime-1a.png" dx 400 layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dx 450 layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dy 150 layer grime atlas hdgrime hflip #true }
                { img "grime-1b.png" dy 150 dx 200 layer grime atlas hdgrime hflip #true }
                { img "grime-4a.png" dy 150 dx 400 layer grime atlas hdgrime hflip #true }
                { img "grime-4b.png" dy 150 dx 450 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "middlefloor-12w.png" dy 146 layer worker atlas hdwalls }
                { img "zoned-left-second-retail.png" layer foreground atlas hddecos }
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "zoned-door-second-retail.png" dy 141.5 layer wallpaper atlas hdwalls }
                { img "uc-retail-1w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dy 150 dx 500 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 35 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 106 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 215 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 279 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 346 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 397 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 443 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 545 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 139 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 229 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 353 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 450 dy 48 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 486 dy 48 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 551 dy 93.5 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 51 dy 150 layer deco atlas hddecos}
                { img "uc-crate-long.png" dx 119 dy 150 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 212 dy 150 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 182 dy 198 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 347 dy 150 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 386 dy 150 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 432 dy 150 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 475 dy 150 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 533 dy 150 layer deco atlas hddecos }
            ]
            workstations [ { dx 69 anim peepworkr } { dx 151 dy 150 anim peepworkf } { dx 473 dy 150 anim peepworkf }  ]
            visitoranchors [ { dx 92 plusorminus 10 } { dx 277 plusorminus 60 } { dx 80 dy 150 plusorminus 100 } { dx 468 dy 150 plusorminus 10 } ]
        }

        retail-level-four-a {
            open [
                { img "retail-4a.png" layer wallpaper atlas hdcom }
                { img "retail-4a-left.png" layer foreground atlas hddecos }
                { img "retail-4a-props-left.png" dx 84 layer deco atlas hddecos }
                { img "retail-4a-props-right.png" dx 250 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 50 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 111 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 161 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 235 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 335 layer deco atlas hddecos }
                { img "uc-light.png" dx 340 layer deco atlas hddecos }
            ]
            workstations [ { dx 175 anim peepworkf } { dx 300 anim peepworkf } ]
            visitoranchors [ { dx 160 plusorminus 35 } { dx 330 plusorminus 25 } ]
        }
        retail-level-four-b {
            open [
                { img "retail-4b.png" layer wallpaper atlas hdcom }
                { img "retail-4a-left.png" layer foreground atlas hddecos }
                { img "retail-4b-props-left.png" dx 144 layer deco atlas hddecos }
                { img "retail-4b-props-right.png" dx 314 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 50 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 111 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 161 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 235 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 335 layer deco atlas hddecos }
                { img "uc-light.png" dx 340 layer deco atlas hddecos }
            ]
            workstations [ { dx 168 anim peepworkf } { dx 331 anim peepworkf } ]
            visitoranchors [ { dx 154 plusorminus 5 } { dx 315 plusorminus 25 } ]
        }
        retail-level-four-c {
            open [
                { img "retail-4c.png" layer wallpaper atlas hdcom }
                { img "retail-4a-left.png" layer foreground atlas hddecos }
                { img "retail-4c-props.png" dx 119 layer deco atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 50 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 111 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 161 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 235 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 335 layer deco atlas hddecos }
                { img "uc-light.png" dx 340 layer deco atlas hddecos }
            ]
            workstations [ { dx 175 anim peepworkf } { dx 300 anim peepworkf } ]
            visitoranchors [ { dx 195 plusorminus 35 } { dx 300 plusorminus 25 } ]
        }
        retail-level-four-d {
            open [
                { img "retail-4d.png" layer wallpaper atlas hdcom }
                { img "retail-4d-left.png" layer foreground atlas hddecos }
                { img "retail-4d-props.png" dx 213 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 50 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 111 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 161 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 235 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 335 layer deco atlas hddecos }
                { img "uc-light.png" dx 340 layer deco atlas hddecos }
            ]
            workstations [ { dx 267 anim peepworkf } ]
            visitoranchors [ { dx 200 plusorminus 100 } ]
        }
        retail-level-four-e {
            open [
                { img "retail-4e.png" layer wallpaper atlas hdcom }
                { img "retail-4d-left.png" layer foreground atlas hddecos }
                { img "retail-4e-props.png" dx 168 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 50 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 111 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 161 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 235 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 335 layer deco atlas hddecos }
                { img "uc-light.png" dx 340 layer deco atlas hddecos }
            ]
            workstations [ { dx 222 anim peepworkf } ]
            visitoranchors [ { dx 222 plusorminus 90 } ]
        }
        retail-level-four-f {
            open [
                { img "retail-4f.png" layer wallpaper atlas hdcom }
                { img "retail-4d-left.png" layer foreground atlas hddecos }
                { img "retail-4f-props.png" dx 148 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 50 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 111 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 161 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 235 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 335 layer deco atlas hddecos }
                { img "uc-light.png" dx 340 layer deco atlas hddecos }
            ]
            workstations [ { dx 203 anim peepworkf } ]
            visitoranchors [ { dx 200 plusorminus 100 } ]
        }



		;; -------------------------------------------------------------------

		;; restaurants

		restaurant-level-one-a {
			open [
                { img "rest-1a.png" layer wallpaper atlas hdcom }
				{ img "rest-1a-props.png" layer deco dx 31 atlas hddecos }
				{ img "rest-1a-left.png" layer foreground atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime }
                { img "grime-2b.png" dx 100 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 10 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 116 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 156 dy 58 layer deco atlas hddecos }
            ]
            workstations [ { dx 50 anim peepworkf } ]
            visitoranchors [ { dx 42 plusorminus 10 } { dx 116 plusorminus 10 } ]
		}
		restaurant-level-one-b {
			open [
                { img "rest-1b.png" layer wallpaper atlas hdcom }
				{ img "rest-1b-props.png" layer deco dx 33 atlas hddecos }
				{ img "rest-1b-left.png" layer foreground atlas hddecos }
                { img "grime-2b.png" layer grime atlas hdgrime }
                { img "grime-2a.png" dx 100 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 10 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 116 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 156 dy 58 layer deco atlas hddecos }
            ]
            workstations [ { dx 50 anim peepworkf } { dx 120 anim peepworkf } ]
            visitoranchors [ { dx 37 plusorminus 10 } { dx 87 plusorminus 10 } ]
		}
		restaurant-level-one-c {
			open [
                { img "rest-1c.png" layer wallpaper atlas hdcom }
				{ img "rest-1c-props.png" layer deco dx 125 atlas hddecos }
				{ img "rest-1c-left.png" layer foreground atlas hddecos }
                { img "grime-1a.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 50 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 10 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 69 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 116 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 156 dy 58 layer deco atlas hddecos }
            ]
            workstations [ { dx 165 anim peepworkf } ]
            visitoranchors [ { dx 28 plusorminus 10 } { dx 82 plusorminus 10 } { dx 147 plusorminus 10 } ]
		}
		restaurant-level-one-d {
			open [
                { img "rest-1d.png" layer wallpaper atlas hdcom }
				{ img "rest-1d-props.png" layer deco dx 35 atlas hddecos }
				{ img "rest-1d-left.png" layer foreground atlas hddecos }
                { img "grime-1b.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 50 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 10 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 69 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 116 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 156 dy 58 layer deco atlas hddecos }
            ]
            workstations [ { dx 50 anim peepworkf } { dx 155 anim peepworkf } ]
            visitoranchors [ { dx 35 plusorminus 10 } { dx 132 plusorminus 35 } ]
		}
		restaurant-level-one-e {
			open [
                { img "rest-1e.png" layer wallpaper atlas hdcom }
				{ img "rest-1e-props.png" layer deco dx 36 atlas hddecos }
				{ img "rest-1e-left.png" layer foreground atlas hddecos }
                { img "grime-1a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 50 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 10 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 69 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 116 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 156 dy 58 layer deco atlas hddecos }
            ]
            workstations [ { dx 50 anim peepworkf } ]
            visitoranchors [ { dx 31 plusorminus 10 } { dx 91 plusorminus 10 } { dx 152 plusorminus 10 } ] 
		}
		restaurant-level-two-a {
			open [
                { img "rest-2a.png" layer wallpaper atlas hdcom }
                { img "rest-2a-left.png" layer foreground atlas hddecos }
                { img "rest-2a-props-1.png" dx 59 layer deco atlas hddecos }
                { img "rest-2a-props-2.png" dx 150 layer deco atlas hddecos  }
                { img "rest-2a-props-3.png" dx 293 layer deco atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime }
                { img "grime-2b.png" dx 100 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-crate-chair.png" dx 25 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 63 dy 51.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 109 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 172 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 266 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 180 dy 48 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 214 dy 48 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 309 dy 48 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 360 layer deco atlas hddecos }
            ]
            workstations [ { dx 169 anim peepworkf } { dx 235 anim peepworkf } { dx 283 anim peepworkf } ]
            visitoranchors [ { dx 149 plusorminus 10 } { dx 218 plusorminus 25 } ]
            patronanchors [
                { dx 70 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 105 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 330 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 350 animm "eat-sit-l-m" animf "eat-sit-l-f" }
            ]
		}

		restaurant-level-two-b {
			open [
                { img "rest-2b.png" layer wallpaper atlas hdcom }
                { img "rest-2b-left.png" layer foreground atlas hddecos }
                { img "rest-2b-props-left.png" dx 59 layer deco atlas hddecos }
                { img "rest-2b-props.png" dx 125 layer deco atlas hddecos }
                { img "rest-2b-props-right.png" dx 315 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-crate-chair.png" dx 25 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 63 dy 51.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 109 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 172 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 266 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 180 dy 48 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 214 dy 48 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 309 dy 48 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 360 layer deco atlas hddecos }
            ]
            workstations [ { dx 170 anim peepworkf } { dx 260 anim peepworkf } ]
            visitoranchors [ { dx 175 plusorminus 15 } { dx 237 plusorminus 20 } ]
            patronanchors [ 
                { dx 50 animm "eat-sit-r-m" animf "eat-sit-r-f" } 
                { dx 94 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 350 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 370 animm "eat-sit-l-m" animf "eat-sit-l-f" }
            ]
		}

		restaurant-level-two-c {
			open [
                { img "rest-2c.png" layer wallpaper atlas hdcom }
                { img "rest-2c-left.png" layer foreground atlas hddecos }
                { img "rest-2c-props.png" dx 68 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime }
             ]
			construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-crate-chair.png" dx 25 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 63 dy 51.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 109 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 172 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 266 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 180 dy 48 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 214 dy 48 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 309 dy 48 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 360 layer deco atlas hddecos }
            ]
            workstations [ { dx 119 anim peepworkf } { dx 239 anim peepworkf } { dx 355 anim peepworkf } ]
            visitoranchors [ { dx 101 plusorminus 80 } { dx 225 plusorminus 80 } {dx 338 plusorminus 20} ]
		}

		restaurant-level-two-d {
			open [
                { img "rest-2d.png" layer wallpaper atlas hdcom }
                { img "rest-2d-left.png" layer foreground atlas hddecos }
                { img "rest-2d-props-left.png" dx 31.5 layer deco atlas hddecos }
                { img "chair-rest-01.png" dx 43.5 layer deco atlas hddecos }
                { img "chair-rest-01.png" dx 73 layer deco atlas hddecos }
                { img "chair-rest-01.png" dx 102.5 layer deco atlas hddecos }
                { img "chair-rest-01.png" dx 132 layer deco atlas hddecos }
                { img "rest-2d-props-right.png" dx 285 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime }
                { img "grime-2a.png" dx 300 layer grime atlas hdgrime }
             ]
			construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-crate-chair.png" dx 25 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 63 dy 51.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 109 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 172 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 266 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 180 dy 48 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 214 dy 48 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 309 dy 48 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 360 layer deco atlas hddecos }
            ]
            workstations [ { dx 48 anim peepworkf } { dx 200 anim peepworkf } { dx 48 anim peepworkf } { dx 200 anim peepworkf } ]
            visitoranchors [ { dx 225 plusorminus 20 } ]
            patronanchors [
                { dx 113 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 142 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 290 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 320 animm "eat-sit-f-m" animf "eat-sit-f-f" }
            ]
		}

		restaurant-level-two-e {
			open [
                { img "rest-2e.png" layer wallpaper atlas hdcom }
                { img "rest-2e-left.png" layer foreground atlas hddecos }
                { img "rest-2e-props.png" dx 29 layer deco atlas hddecos }
                { img "rest-2e-props-right.png" dx 265 layer deco atlas hddecos }
                { img "grime-2.png" layer grime atlas hdgrime }
                { img "grime-2.png" dx 100 layer grime atlas hdgrime }
                { img "grime-2.png" dx 200 layer grime atlas hdgrime }
                { img "grime-2.png" dx 300 layer grime atlas hdgrime }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 150 layer grime atlas hdgrime }
                { img "grime-2b.png" dx 300 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-crate-chair.png" dx 25 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 63 dy 51.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 109 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 172 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 266 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 180 dy 48 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 214 dy 48 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 309 dy 48 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 360 layer deco atlas hddecos }
            ]
            workstations [ { dx 76 anim peepworkf } { dx 182 anim peepworkf } ]
            visitoranchors [ { dx 186 plusorminus 35 } ]
            patronanchors [
                { dx 258 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 305 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 336 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 360 animm "eat-sit-l-m" animf "eat-sit-l-f" }
            ]
		}

		restaurant-level-three-a {
			open [
                { img "rest-3a.png" layer wallpaper atlas hdcom }
                { img "rest-3a-left.png" layer foreground atlas hddecos }
                { img "rest-3a-table-1.png" dx 74 layer deco atlas hddecos }
                { img "rest-3a-props-left.png" dx 26 layer deco atlas hddecos }
                { img "chair-rest-02.png" dx 224 layer deco atlas hddecos }
                { img "chair-rest-02.png" dx 258 layer deco atlas hddecos }
                { img "chair-rest-02.png" dx 292 layer deco atlas hddecos }
                { img "chair-rest-02.png" dx 326 layer deco atlas hddecos }
                { img "rest-3a-props-center.png" dx 357 dy 8 layer deco atlas hddecos }
                { img "rest-3a-table-2.png" dx 535 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 550 layer grime atlas hdgrime }
                { img "grime-2a.png" dx 700 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "uc-drywall-tools.png" dx 57 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 119 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 173 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 213 dy 51.5 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 263 layer deco atlas hddecos hflip #true }
                { img "uc-toolbox-2.png" dx 275 dy 51.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 351 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 412 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 428 dy 48 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 504 layer deco atlas hddecos hflip #true }
                { img "uc-crate-chair.png" dx 570 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 663 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 408 dy 36 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 758 layer deco atlas hddecos }
            ]
            workstations [ { dx 40 anim peepworkf } { dx 375 anim peepworkf } { dx 433 anim peepworkf } ]
            visitoranchors [ { dx 19 plusorminus 10 } { dx 425 plusorminus 35 } ]
            patronanchors [
                { dx 70 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 92 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 122 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 237 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 305 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 530 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 572 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 673 animm "eat-sit-r-m" animf "eat-sit-r-f" }
            ]
		}
        restaurant-level-three-b-italian {
            open [
                { img "rest-3b-italian.png" layer wallpaper atlas hdcom }
                { img "rest-3b-italian-left.png" layer foreground atlas hddecos }
                { img "chair-rest-02.png" dx 228 layer deco atlas hddecos }
                { img "chair-rest-02.png" dx 265 layer deco atlas hddecos }
                { img "rest-3a-props-left.png" dx 35 layer deco atlas hddecos }
                { img "rest-3b-italian-props-center.png" dx 293 layer deco atlas hddecos }
                { img "rest-3b-italian-table-1.png" dx 588 layer deco atlas hddecos }
                { img "rest-3b-italian-table-2.png" dx 707 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 550 layer grime atlas hdgrime }
                { img "grime-2b.png" dx 700 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "uc-drywall-tools.png" dx 57 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 119 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 173 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 213 dy 51.5 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 263 layer deco atlas hddecos hflip #true }
                { img "uc-toolbox-2.png" dx 275 dy 51.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 351 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 412 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 428 dy 48 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 504 layer deco atlas hddecos hflip #true }
                { img "uc-crate-chair.png" dx 570 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 663 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 408 dy 36 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 758 layer deco atlas hddecos }
            ]
            workstations [ { dx 44 anim peepworkf } { dx 349 anim peepworkf } { dx 425 anim peepworkf } ]
            visitoranchors [ { dx 30 plusorminus 10 } { dx 349 plusorminus 50 } ]
            patronanchors [
                { dx 241 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 274 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 590 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 626 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 650 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 739 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 768 animm "eat-sit-l-m" animf "eat-sit-l-f" }
            ]
        }
        restaurant-level-three-b-mexican {
            open [
                { img "rest-3b-mexican.png" layer wallpaper atlas hdcom }
                { img "rest-3b-mexican-left.png" layer foreground atlas hddecos }
                { img "rest-3a-props-left.png" dx 35 layer deco atlas hddecos }
                { img "chair-rest-02.png" dx 228 layer deco atlas hddecos }
                { img "chair-rest-02.png" dx 261 layer deco atlas hddecos }
                { img "chair-rest-02.png" dx 293 layer deco atlas hddecos }
                { img "rest-3b-mexican-props-center.png" dx 319.5 layer deco atlas hddecos }
                { img "rest-3b-mexican-table-1.png" dx 590 layer deco atlas hddecos }
                { img "rest-3b-mexican-table-2.png"  dx 706 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 500 layer grime atlas hdgrime }
                { img "grime-2a.png" dx 700 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "uc-drywall-tools.png" dx 57 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 119 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 173 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 213 dy 51.5 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 263 layer deco atlas hddecos hflip #true }
                { img "uc-toolbox-2.png" dx 275 dy 51.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 351 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 412 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 428 dy 48 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 504 layer deco atlas hddecos hflip #true }
                { img "uc-crate-chair.png" dx 570 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 663 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 408 dy 36 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 758 layer deco atlas hddecos }
            ]
            workstations [ { dx 44 anim peepworkf } { dx 350 anim peepworkf } { dx 425 anim peepworkf } ]
            visitoranchors [ { dx 30 plusorminus 10 } { dx 355 plusorminus 30 } ]
            patronanchors [
                { dx 154 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 241 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 274 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 306 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 590 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 624 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 737 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 755 animm "eat-sit-l-m" animf "eat-sit-l-f" }
            ]
        }
        restaurant-level-three-c-family {
            open [
                { img "rest-3c-family.png" layer wallpaper atlas hdcom }
                { img "rest-3c-family-left.png" layer foreground atlas hddecos }
                { img "rest-3c-family-props.png" dx 170 layer deco atlas hddecos }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 150 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 300 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 500 layer grime atlas hdgrime }
                { img "grime-2b.png" dx 700 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "uc-drywall-tools.png" dx 57 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 119 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 173 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 213 dy 51.5 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 263 layer deco atlas hddecos hflip #true }
                { img "uc-toolbox-2.png" dx 275 dy 51.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 351 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 412 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 428 dy 48 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 504 layer deco atlas hddecos hflip #true }
                { img "uc-crate-chair.png" dx 570 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 663 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 408 dy 36 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 758 layer deco atlas hddecos }
            ]
            workstations [ { dx 189 anim peepworkf } { dx 313 anim peepworkf } ]
            visitoranchors [ { dx 140 plusorminus 70 } ]
            patronanchors [
                { dx 409 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 447 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 510 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 550 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 612 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 655 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 713 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 752 animm "eat-sit-l-m" animf "eat-sit-l-f" }
            ]
        }
        restaurant-level-three-c-brunch {
            open [
                { img "rest-3c-brunch.png" layer wallpaper atlas hdcom }
                { img "rest-2c-left.png" layer foreground atlas hddecos }
                { img "rest-3c-brunch-props.png" dx 31 layer deco atlas hddecos }
                { img "rest-3c-brunch-table-1.png" dx 572 layer deco atlas hddecos }
                { img "rest-3c-brunch-table-2.png" dx 695 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime hflip #true }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime hflip #true }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime hflip #true }
                { img "grime-4b.png" dx 500 layer grime atlas hdgrime hflip #true }
                { img "grime-2a.png" dx 700 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 700 layer wallpaper atlas hdwalls }
                { img "uc-drywall-tools.png" dx 57 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 119 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 173 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 213 dy 51.5 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 263 layer deco atlas hddecos hflip #true }
                { img "uc-toolbox-2.png" dx 275 dy 51.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 351 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 412 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 428 dy 48 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 504 layer deco atlas hddecos hflip #true }
                { img "uc-crate-chair.png" dx 570 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 663 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 408 dy 36 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 758 layer deco atlas hddecos }
            ]
            workstations [ { dx 65 anim peepworkf } { dx 136 anim peepworkf } { dx 233 anim peepworkf } ]
            visitoranchors [ { dx 152 plusorminus 50 } ]
            patronanchors [
                { dx 450 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 511 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 572 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 605 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 631 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 692 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 727 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 756 animm "eat-sit-l-m" animf "eat-sit-l-f" }
            ]
        }
		restaurant-level-four-a {
            open [
                { img "rest-4a.png" layer wallpaper atlas hdtwofloors }
                { img "rest-4a-left.png" layer foreground atlas hddecos }
                { img "rest-4a-props-left.png" dx 30 layer deco atlas hddecos }
                { img "chair-rest-03.png" dx 210 layer deco atlas hddecos }
                { img "chair-rest-03.png" dx 246 layer deco atlas hddecos }
                { img "rest-4a-props-right.png" dx 286.5 layer deco atlas hddecos }
                { img "rest-4a-table-1.png" dx 450 layer deco atlas hddecos }
                { img "rest-4a-table-2.png" dx 590 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 550 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-trash-open.png" dx 103 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 168 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 243 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 311 layer deco atlas  hddecos }
                { img "uc-bucket-paint.png" dy 58.5 dx 356 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 399 layer deco atlas hddecos }
                { img "uc-box-4.png" dy 58.5 dx 410 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 466 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 535 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 588 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 638 layer deco atlas hddecos }
            ]
            workstations [ 
                { dx 73 anim peepworkb } 
                { dx 115 anim peepworkb } 
                { dx 169 anim peepworkb } 
                { dx 24 anim peepworkf }
                { dx 360 anim peepworkf }
                { dx 394 anim peepworkf }
            ]
            visitoranchors [ { dx 93 plusorminus 30 } { dx 323 plusorminus 30 } ]
            patronanchors [
                { dx 225 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 261 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 438 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 489 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 520 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 580 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 629 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 661 animm "eat-sit-l-m" animf "eat-sit-l-f" }
            ]
        }
        restaurant-level-four-b {
            open [
                { img "rest-4b.png" layer wallpaper atlas hdtwofloors }
                { img "rest-4b-left.png" layer foreground atlas hddecos }
                { img "rest-4b-props.png" dx 78 layer deco atlas hddecos }
                { img "chair-rest-04.png" dx 154 layer deco atlas hddecos }
                { img "chair-rest-04.png" dx 195 layer deco atlas hddecos }
                { img "chair-rest-04.png" dx 235 layer deco atlas hddecos }
                { img "chair-rest-04.png" dx 278 layer deco atlas hddecos }
                { img "rest-4b-table-1.png" dx 594 layer deco atlas hddecos  }
                { img "grime-4a.png" layer grime atlas hdgrime hflip #true }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dx 400 layer grime atlas hdgrime hflip #true }
                { img "grime-3b.png" dx 550 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-trash-open.png" dx 103 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 168 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 243 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 311 layer deco atlas  hddecos }
                { img "uc-bucket-paint.png" dy 58.5 dx 356 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 399 layer deco atlas hddecos }
                { img "uc-box-4.png" dy 58.5 dx 410 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 466 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 535 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 588 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 638 layer deco atlas hddecos }
            ]
            workstations [
                { dx 51 anim peepworkb }
                { dx 95 anim peepworkb }
                { dx 127 anim peepworkb }
                { dx 332 anim peepworkf }
                { dx 360 anim peepworkf }
                { dx 550 anim peepworkf }
            ]
            visitoranchors [ { dx 70 plusorminus 35 } { dx 360 plusorminus 25 } ]
            patronanchors [
                { dx 171 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 212 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 252 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 295 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 432 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 502 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 629 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 657 animm "eat-sit-l-m" animf "eat-sit-l-f" }
            ]
        }
        restaurant-level-four-c {
            open [
                { img "rest-4c.png" layer wallpaper atlas hdtwofloors }
                { img "rest-4c-left.png" layer foreground atlas hddecos }
                { img "chair-rest-04.png" dx 392 layer deco atlas hddecos }
                { img "chair-rest-04.png" dx 439 layer deco atlas hddecos }
                { img "chair-rest-04.png" dx 485 layer deco atlas hddecos }
                { img "rest-4c-props-right.png" dx 588.5 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 550 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-trash-open.png" dx 103 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 168 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 243 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 311 layer deco atlas  hddecos }
                { img "uc-bucket-paint.png" dy 58.5 dx 356 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 399 layer deco atlas hddecos }
                { img "uc-box-4.png" dy 58.5 dx 410 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 466 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 535 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 588 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 638 layer deco atlas hddecos }
            ]
            workstations [
                { dx 194 anim peepworkf } 
                { dx 580 anim peepworkb }
                { dx 633 anim peepworkb }
                { dx 675 anim peepworkf }
            ]
            visitoranchors [ { dx 193 plusorminus 40 } { dx 630 plusorminus 30 } ]
            patronanchors [
                { dx 64 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 126 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 245 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 306 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 409 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 456 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 503 animm "eat-sit-b-m" animf "eat-sit-b-f" }
            ]
        }
        restaurant-level-four-d {
            open [
                { img "rest-4d.png" layer wallpaper atlas hdtwofloors }
                { img "rest-4d-left.png" layer foreground atlas hddecos }
                { img "rest-4d-table-1.png" dx 243 layer deco atlas hddecos }
                { img "chair-rest-05.png" dx 390 layer deco atlas hddecos }
                { img "chair-rest-05.png" dx 426 layer deco atlas hddecos }
                { img "chair-rest-05.png" dx 462 layer deco atlas hddecos }
                { img "chair-rest-05.png" dx 498 layer deco atlas hddecos }
                { img "rest-4d-props.png" dx 529 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime hflip #true }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dx 400 layer grime atlas hdgrime hflip #true }
                { img "grime-3b.png" dx 550 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-trash-open.png" dx 103 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 168 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 243 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 311 layer deco atlas  hddecos }
                { img "uc-bucket-paint.png" dy 58.5 dx 356 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 399 layer deco atlas hddecos }
                { img "uc-box-4.png" dy 58.5 dx 410 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 466 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 535 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 588 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 638 layer deco atlas hddecos }
            ]
            workstations [
                { dx 50 anim peepworkf }
                { dx 175 anim peepworkf }
                { dx 350 anim peepworkf }
                { dx 550 anim peepworkb }
                { dx 600 anim peepworkb }
                { dx 660 anim peepworkb }
            ]
            visitoranchors [ { dx 50 plusorminus 40 } { dx 626 plusorminus 40 } ]
            patronanchors [
                { dx 227 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 277 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 300  animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 405 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 441 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 477 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 513 animm "eat-sit-b-m" animf "eat-sit-b-f" }
            ]
        }
        restaurant-level-four-e {
            open [
                { img "rest-4e.png" layer wallpaper atlas hdtwofloors }
                { img "rest-4e-left.png" layer foreground atlas hddecos }
                { img "chair-rest-05.png" dx 245 layer deco atlas hddecos }
                { img "chair-rest-05.png" dx 281 layer deco atlas hddecos }
                { img "chair-rest-05.png" dx 319 layer deco atlas hddecos }
                { img "rest-4e-props-right.png" dx 420 layer deco atlas hddecos }
                { img "rest-4e-table-1.png" dx 593 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 550 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-trash-open.png" dx 103 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 168 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 243 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 311 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dy 58.5 dx 356 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 399 layer deco atlas hddecos }
                { img "uc-box-4.png" dy 58.5 dx 410 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 466 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 535 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 588 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 638 layer deco atlas hddecos }
            ]
            workstations [
                { dx 208 anim peepworkf }
                { dx 405 anim peepworkb }
                { dx 365 anim peepworkb }
                { dx 440 anim peepworkb }
                { dx 508 anim peepworkf }
                { dx 546 anim peepworkf }
            ]
            visitoranchors [ { dx 102 plusorminus 40 } { dx 505 plusorminus 40 } ]
            patronanchors [
                { dx 260 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 296 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 334 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 585 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 630 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 655 animm "eat-sit-l-m" animf "eat-sit-l-f" }
            ]
        }
        restaurant-level-four-f {
            open [
                { img "rest-4f.png" layer wallpaper atlas hdtwofloors }
                { img "rest-4f-left.png" layer foreground atlas hddecos }
                { img "chair-rest-04.png" dx 169 layer deco atlas hddecos }
                { img "chair-rest-04.png" dx 304 layer deco atlas hddecos }
                { img "chair-rest-04.png" dx 342 layer deco atlas hddecos }
                { img "chair-rest-04.png" dx 388 layer deco atlas hddecos }
                { img "rest-4f-props.png" dx 429.5 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime hflip #true }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime hflip #true }
                { img "grime-3a.png" dx 400 layer grime atlas hdgrime hflip #true } 
                { img "grime-3b.png" dx 550 layer grime atlas hdgrime hflip #true }
            ]
            construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 600 layer wallpaper atlas hdwalls }
                { img "uc-trash-open.png" dx 103 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 168 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 243 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 311 layer deco atlas  hddecos }
                { img "uc-bucket-paint.png" dy 58.5 dx 356 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 399 layer deco atlas hddecos }
                { img "uc-box-4.png" dy 58.5 dx 410 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 466 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 535 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 588 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 638 layer deco atlas hddecos }
            ]
            workstations [
                { dx 446 anim peepworkb }
                { dx 487 anim peepworkf }
                { dx 530 anim peepworkb }
                { dx 35 anim peepworkf }
            ]
            visitoranchors [ { dx 500 plusorminus 75 } ]
            patronanchors [
                { dx 130 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 186 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 230 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 321 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 359 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 405 animm "eat-sit-b-m" animf "eat-sit-b-f" }
            ]
        }
        restaurant-rooftop-small {
            open [
                { img "rest-roof-small.png" layer wallpaper atlas hdtwofloors }
                { img "rest-roof-small-door.png" dx 400 layer foreground atlas hddecos }
                { img "rest-roof-small-left.png" dx 81 layer deco atlas hddecos }
                { img "rest-roof-small-center.png" dx 242.5 layer deco atlas hddecos }
                { img "rest-roof-small-right.png" dx 548.5 layer deco atlas hddecos }
                { img "chair-rest-06.png" dx 476 layer deco atlas hddecos }
                { img "chair-rest-06.png" dx 514 layer deco atlas hddecos }
                { img "roof-railing-left.png" layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 50 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 100 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 150 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 200 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 250 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 300 layer foreground atlas hdwalls }
                { img "roof-railing-right.png" dx 350 layer foreground atlas hdwalls }
                { img "grime-3a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-1b.png" dx 550 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-pallet-concrete.png" dx 42 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 122 layer deco atlas hddecos }
                { img "uc-pallet-planks.png" dx 156 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 259 layer deco atlas hddecos }
                { img "uc-light.png" dx 300 layer deco atlas hddecos }
                { img "uc-restaurant-door.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-1w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 447 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 507 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 543 dy 58.5 layer deco atlas hddecos }
                { img "roof-railing-left.png" layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 50 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 100 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 150 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 200 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 250 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 300 layer foreground atlas hdwalls }
                { img "roof-railing-right.png" dx 350 layer foreground atlas hdwalls }
            ]
            workstations [
                { dx 195 anim peepworkf }
                { dx 580 anim peepworkf }
            ]
            visitoranchors [
                { dx 350 plusorminus 20 }
                { dx 460 plusorminus 30 }
            ]
            patronanchors [
                { dx 83 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 142 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 245 animm "eat-sit-r-m" animf "eat-sit-r-f" }
                { dx 307 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 489 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 527 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
            ]
        }
        restaurant-rooftop-large {
            open [
                { img "rest-roof-large.png" layer wallpaper atlas hdtwofloors }
                { img "rest-roof-large-door.png" layer foreground atlas hddecos }
                { img "chair-rest-06.png" dx 53 layer deco atlas hddecos }
                { img "chair-rest-06.png" dx 85 layer deco atlas hddecos }
                { img "rest-roof-large-props-one.png" dx 113 layer deco atlas hddecos }
                { img "chair-rest-06.png" dx 369 layer deco atlas hddecos }
                { img "rest-roof-large-props-two.png" dx 396.5 layer deco atlas hddecos }
                { img "roof-railing-right.png" dx 300 layer foreground atlas hdwalls hflip #true }
                { img "rest-roof-large-props-three.png" dx 606 layer deco atlas hddecos }
                { img "rest-roof-large-props-four.png" dx 788 layer deco atlas hddecos }
                { img "rest-roof-large-props-five.png" dx 973 layer deco atlas hddecos }
                { img "roof-railing-middle.png" dx 350 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 400 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 450 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 500 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 550 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 600 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 650 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 700 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 750 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 800 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 850 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 900 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 950 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 1000 layer foreground atlas hdwalls }
                { img "roof-railing-left.png" dx 1050 layer foreground atlas hdwalls hflip #true }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 150 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-crate-chair.png" dx 45 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 83 dy 48.5 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 133 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 183 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 195 dy 46 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 231 dy 46 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 442 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 492 dy 36 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 550 layer deco atlas hddecos }
                { img "uc-pallet-planks.png" dx 603 layer deco atlas hddecos }
                { img "uc-light.png" dx 710 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 867 layer deco atlas hddecos }
                { img "uc-pallet-concrete.png" dx 900 layer deco atlas hddecos }
                { img "uc-light.png" dx 1031 layer deco atlas hddecos }
                { img "roof-railing-right.png" dx 300 layer foreground atlas hdwalls hflip #true }
                { img "roof-railing-middle.png" dx 350 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 400 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 450 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 500 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 550 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 600 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 650 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 700 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 750 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 800 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 850 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 900 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 950 layer foreground atlas hdwalls }
                { img "roof-railing-middle.png" dx 1000 layer foreground atlas hdwalls }
                { img "roof-railing-left.png" dx 1050 layer foreground atlas hdwalls hflip #true }
            ]
            workstations [
                { dx 145 anim peepworkf }
                { dx 440 anim peepworkf }
                { dx 733 anim peepworkf }
            ]
            visitoranchors [
                { dx 510 plusorminus 30 }
                { dx 250 plusorminus 30 }
            ]
            patronanchors [
                { dx 63 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 95 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 382 dy 8 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 604 animm "eat-sit-r-m" animm "eat-sit-r-f" }
                { dx 658 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 840 animm "eat-sit-l-m" animf "eat-sit-l-f" }
                { dx 975 animm "eat-sit-r-m" animm "eat-sit-r-f" }
                { dx 1020 animm "eat-sit-l-m" animf "eat-sit-l-f" }
            ]
        }

		;; ------------------------------------------------------------------

		;; offices

		office-level-one-a {
			open [
                { img "office-1a.png" layer wallpaper atlas hdcom }
				{ img "chair-desk-1.png" layer deco dx 158  atlas hddecos }
				{ img "office-1b-left.png" layer foreground atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime }
                { img "grime-2b.png" dx 100 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 28 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 88 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 160 dy 50 layer deco atlas hddecos }
              ]

			workstations [ { dx 163 anim peepworkl } ]
            serviceanchors [ { dx 105 plusorminus 5 } ] 
		}
		office-level-one-b {
			open [
                { img "office-1b.png" layer wallpaper atlas hdcom }
				{ img "office-1b-props.png" layer deco dx 79 atlas hddecos }
				{ img "office-1b-left.png" layer foreground atlas hddecos }
                { img "grime-2b.png" layer grime atlas hdgrime }
                { img "grime-2a.png" dx 100 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 28 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 88 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 160 dy 50 layer deco atlas hddecos }
              ]
			workstations [ { dx 125 anim peepworkf } ]
            serviceanchors [ { dx 82 } ]
		}
		office-level-one-c {
			open [
                { img "office-1c.png" layer wallpaper atlas hdcom }
				{ img "office-1c-props.png" layer deco dx 75 atlas hddecos }
				{ img "office-1c-left.png" layer foreground atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-1b.png" dx 150 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 28 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 88 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 160 dy 50 layer deco atlas hddecos }
              ]
			workstations [ { dx 130 anim peepworkf } ]
            serviceanchors [ { dx 132.5 } { dx 88 } ]
            visitoranchors [ { dx 115 } ]
		}
		office-level-one-d {
			open [
                { img "office-1d.png" layer wallpaper atlas hdcom }
				{ img "office-1d-left.png" layer foreground atlas hddecos }
				{ img "office-1d-props.png" layer deco dx 63 atlas hddecos }
                { img "chair-desk-1-right.png" dx 41 layer worker atlas hddecos }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-1a.png" dx 150 layer grime atlas hdgrime }
            ]
			construction[
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 28 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 88 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 160 dy 50 layer deco atlas hddecos }
              ]
			workstations [ { dx 72 anim peepworkr } ]
            serviceanchors [ { dx 110 } ]
            visitoranchors [ { dx 135 } ]
		}
        office-level-one-d-alt {
            open [
                { img "office-1d.png" layer wallpaper atlas hdcom }
                { img "office-1d-left.png" layer foreground atlas hddecos }
                { img "office-1d-props-alt.png" layer worker dx 42 atlas hddecos }
                { img "chair-desk-1.png" dx 90 layer deco atlas hddecos }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-1a.png" dx 150 layer grime atlas hdgrime }
            ]
            construction[
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 28 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 88 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 160 dy 50 layer deco atlas hddecos }
              ]
            workstations [ { dx 97 anim peepworkl } ]
            serviceanchors [ { dx 165 } ]
            visitoranchors [ { dx 34 } ]
        }
		office-level-one-e {
			open [
                { img "office-1e.png" layer wallpaper atlas hdcom }
    			{ img "chair-desk-1.png" layer deco dx 107 atlas hddecos }
    			{ img "office-1e-left.png" layer foreground atlas hddecos }
                { img "office-1e-props.png" dx 59 layer worker atlas hddecos }
                { img "grime-1a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 50 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 28 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 88 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 160 dy 50 layer deco atlas hddecos }
              ]
			workstations [ { dx 116 anim peepworkl }  ]
            serviceanchors [ { dx 37 } ]
            visitoranchors [ { dx 53 } ]
		}
        office-level-one-e-alt {
            open [
                { img "office-1e.png" layer wallpaper atlas hdcom }
                { img "chair-desk-1.png" layer deco dx 117.5 atlas hddecos }
                { img "office-1e-left.png" layer foreground atlas hddecos }
                { img "office-1e-props-alt.png" dx 63.5 layer worker atlas hddecos }
                { img "grime-1a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 50 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 28 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 88 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 160 dy 50 layer deco atlas hddecos }
              ]
            workstations [ { dx 125 anim peepworkl }  ]
            serviceanchors [ { dx 37 } ]
            visitoranchors [ { dx 53 } ]
        }
		office-level-two-a {
			open [
                { img "office-2a.png" layer wallpaper atlas hdcom }
                { img "office-1e-left.png" layer foreground atlas hddecos }
                { img "chair-desk-12.png" dx 206 layer deco atlas hddecos }
                { img "office-2a-props.png" dx 333 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 43 layer deco atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 109 dy 50 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 163 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 174 dy 58.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 223 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 282 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 291 dy 48 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 325 dy 48 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 368 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 395 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 445 layer deco atlas hddecos }
             ]
			workstations [ { dx 214 anim peepworkl } { dx 424 anim peepworkf } ]
            serviceanchors [ { dx 148 tasktype servicecopy } { dx 256 plusorminus 150 tasktype servicejanitor } { dx 50 tasktype servicecatering } { dx 305 tasktype servicestorage } ]
            visitoranchors [ { dx 50 } { dx 166 } ]
		}
		office-level-two-b-dentist {
			open [
                { img "office-2b-dentist.png" layer wallpaper atlas hdcom }
                { img "office-2b-left.png" layer foreground atlas hddecos }
                { img "chair-desk-1.png" dx 204 layer deco atlas hddecos }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 150 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime }
             ]
			construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 43 layer deco atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 109 dy 50 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 163 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 174 dy 58.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 223 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 282 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 291 dy 48 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 325 dy 48 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 368 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 395 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 445 layer deco atlas hddecos }
             ]
			workstations [ { dx 206 anim peepworkl } { dx 365 anim peepworkr } ]
            serviceanchors [ { dx 153 } { dx 67 plusorminus 20 tasktype servicejanitor } ]
            visitoranchors [ { dx 137 } { dx 36 } ]
		}
        office-level-two-b-doctor {
            open [
                { img "office-2b-doctor.png" layer wallpaper atlas hdcom }
                { img "office-2b-left.png" layer foreground atlas hddecos }
                { img "chair-desk-1.png" dx 204 layer deco atlas hddecos }
                { img "grime-3b.png" layer grime atlas hdgrime }
                { img "grime-3a.png" dx 150 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 300 layer grime atlas hdgrime }
             ]
            construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 43 layer deco atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 109 dy 50 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 163 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 174 dy 58.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 223 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 282 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 291 dy 48 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 325 dy 48 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 368 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 395 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 445 layer deco atlas hddecos }
             ]
            workstations [ { dx 206 anim peepworkl } { dx 365 anim peepworkr } ]
            serviceanchors [ { dx 153 } { dx 67 plusorminus 20 tasktype servicejanitor } ]
            visitoranchors [ { dx 137 } { dx 36 } ]
        }
		office-level-two-c {
			open [
                { img "office-2c.png" layer wallpaper atlas hdcom }
                { img "office-2c-left.png" layer foreground atlas hddecos }
                { img "chair-desk-3.png" dx 217 layer deco atlas hddecos }
                { img "office-1b-props.png" dx 310 layer deco atlas hddecos }
                { img "chair-desk-3.png" dx 459 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-2b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 43 layer deco atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 109 dy 50 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 163 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 174 dy 58.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 223 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 282 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 291 dy 48 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 325 dy 48 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 368 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 395 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 445 layer deco atlas hddecos }
            ]
			workstations [ { dx 223 anim peepworkl } { dx 352 anim peepworkf } { dx 472 anim peepworkl } ]
            serviceanchors [ { dx 143 } { dx 238  plusorminus 75 tasktype servicejanitor } { dx 418 tasktype servicecomputer } ]
		}
		office-level-two-d {
			open [
                { img "office-2d.png" layer wallpaper atlas hdcom }
				{ img "office-2d-left.png" layer foreground atlas hddecos }
                { img "chair-desk-3.png" dx 170 layer deco atlas hddecos }
                { img "chair-desk-7.png" dx 226 layer deco atlas hddecos }
                { img "office-2d-props.png" dx 333 layer deco atlas hddecos }
                { img "chair-desk-13.png" dx 436 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-2a.png" dx 200 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 300 layer grime atlas hdgrime }
            ]
			construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 43 layer wallpaper atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 109 dy 50 layer wallpaper atlas hddecos }
                { img "uc-crate-short.png" dx 163 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 174 dy 58.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 223 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 282 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 291 dy 48 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 325 dy 48 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 368 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 395 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 445 layer deco atlas hddecos }
             ]
			workstations [ { dx 176 anim peepworkl } { dx 368 anim peepworkf } { dx 442 anim peepworkl } ]
            serviceanchors [ { dx 93 } { dx 390 plusorminus 50 tasktype servicejanitor } ]
		}
        office-level-two-e {
            open [
                { img "office-2d.png" layer wallpaper atlas hdcom }
                { img "office-2d-left.png" layer foreground atlas hddecos }
                { img "chair-desk-3.png" dx 170 layer deco atlas hddecos }
                { img "chair-desk-7.png" dx 226 layer deco atlas hddecos }
                { img "office-2e-props.png" dx 336 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-2a.png" dx 200 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 300 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 43 layer wallpaper atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 109 dy 50 layer wallpaper atlas hddecos }
                { img "uc-crate-short.png" dx 163 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 174 dy 58.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 223 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 282 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 291 dy 48 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 325 dy 48 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 368 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 395 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 445 layer deco atlas hddecos }
             ]
            workstations [ { dx 176 anim peepworkl } { dx 375 anim peepworkf } { dx 243 anim peepworkb } ]
            serviceanchors [ { dx 93 } { dx 390 plusorminus 50 tasktype servicejanitor } ]
        }
        office-level-two-f {
            open [
                { img "office-2a.png" layer wallpaper atlas hdcom }
                { img "office-1e-left.png" layer foreground atlas hddecos }
                { img "chair-desk-12.png" dx 206 layer deco atlas hddecos }
                { img "office-2f-props.png" dx 339 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 43 layer deco atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 109 dy 50 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 163 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 174 dy 58.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 223 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 282 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 291 dy 48 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 325 dy 48 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 368 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 395 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 445 layer deco atlas hddecos }
             ]
            workstations [ { dx 214 anim peepworkl } { dx 424 anim peepworkf } ]
            serviceanchors [ { dx 148 tasktype servicecopy } { dx 256 plusorminus 150 tasktype servicejanitor } { dx 50 tasktype servicecatering } { dx 305 tasktype servicestorage } ]
            visitoranchors [ { dx 50 } { dx 166 } ]
        }
		office-level-three-a {
            open [
                { img "office-3a.png" layer wallpaper atlas hdcom }
                { img "office-3a-left.png" layer foreground atlas hddecos }
                { img "office-3a-props.png" dx 32 layer deco atlas hddecos }
                { img "chair-desk-13.png" dx 234 layer deco atlas hddecos }
                { img "chair-desk-14.png" dx 346 layer deco atlas hddecos }
                { img "chair-desk-13.png" dx 461 layer deco atlas hddecos }
                { img "chair-desk-13.png" dx 704 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 550 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 700 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 350 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 550 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 650 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 51 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 114 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 159 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 164 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 221 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 266 dy 50 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 338 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 338 dy 16.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 370 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 403 dy 50 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 485 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 515 dy 36 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 583 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 633 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 638 dy 23 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 664 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 720 layer deco atlas hddecos }
            ]
            workstations [ { dx 72 anim peepworkf } { dx 240 anim peepworkl } { dx 363 anim peepworkb } { dx 467 anim peepworkl } { dx 710 anim peepworkl } ]
            serviceanchors [ { dx 40 } { dx 357 plusorminus 150 tasktype servicejanitor } { dx 357 plusorminus 150 tasktype servicesecurity } { dx 199 tasktype servicecomputer } { dx 605 tasktype serviceauditors } { dx 605 tasktype servicedesign } ]
            visitoranchors [ { dx 70 } ]
        }
        office-level-three-b {
            open [
                { img "office-3b.png" layer wallpaper atlas hdcom }
                { img "office-3a-left.png" layer foreground atlas hddecos }
                { img "office-3b-props-left.png" dx 31 layer deco atlas hddecos }
                { img "chair-desk-1.png" dx 234 layer deco atlas hddecos }
                { img "chair-desk-1.png" dx 322 layer deco atlas hddecos }
                { img "chair-desk-4.png" dx 385 layer deco atlas hddecos }
                { img "chair-desk-1.png" dx 705 layer deco atlas hddecos }
                { img "grime-4b.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 550 layer grime atlas hdgrime }
                { img "grime-1b.png" dx 700 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 350 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 550 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 650 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 51 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 114 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 159 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 164 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 221 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 266 dy 50 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 338 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 338 dy 16.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 370 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 403 dy 50 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 485 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 515 dy 36 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 583 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 633 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 638 dy 23 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 664 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 720 layer deco atlas hddecos }
            ]
            workstations [ { dx 76 anim peepworkf } { dx 210 anim peepworkr } { dx 298 anim peepworkr } { dx 408 anim peepworkb } { dx 707 anim peepworkl } ]
            serviceanchors [ { dx 203 } { dx 357 plusorminus 150 tasktype servicejanitor } { dx 357 plusorminus 150 tasktype servicesecurity } { dx 488 tasktype servicecatering } { dx 605 tasktype servicetemps } ]
            visitoranchors [ { dx 80 } ]
        }
        office-level-three-c {
            open [
                { img "office-3c.png" layer wallpaper atlas hdcom }
                { img "office-3c-left.png" layer foreground atlas hddecos }
                { img "office-3c-deco.png" dx 60 dy 99 layer worker atlas hddecos }
                { img "office-3c-props-left.png" dx 31 layer deco atlas hddecos }
                { img "office-3c-props-center.png" dx 215 layer deco atlas hddecos }
                { img "chair-desk-3.png" dx 523 layer deco atlas hddecos }
                { img "chair-desk-7.png" dx 668 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 550 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 700 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 350 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 550 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 650 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 51 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 114 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 159 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 164 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 221 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 266 dy 50 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 338 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 338 dy 16.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 370 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 403 dy 50 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 485 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 515 dy 36 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 583 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 633 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 638 dy 23 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 664 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 720 layer deco atlas hddecos }
            ]
            workstations [ { dx 76 anim peepworkf } { dx 240 anim peepworkf} { dx 530 anim peepworkl } { dx 680 anim peepworkb } ]
            serviceanchors [ { dx 81 } { dx 357 plusorminus 150 tasktype servicejanitor } { dx 357 plusorminus 150 tasktype servicesecurity } { dx 259 tasktype servicetemps } { dx 259 tasktype servicefitness } ]
            visitoranchors [ { dx 95 } { dx 375 } ]
        }
        office-level-three-d-one {
            open [
                { img "office-3d-1.png" layer wallpaper atlas hdcom }
                { img "office-3d-left.png" layer foreground atlas hddecos }
                { img "office-3d-props-left.png" dx 32 layer deco atlas hddecos }
                { img "chair-desk-9.png" dx 247 layer deco atlas hddecos }
                { img "chair-desk-10.png" dx 350 layer deco atlas hddecos }
                { img "chair-desk-10.png" dx 452 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 500 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 700 layer grime atlas hdgrime }
            ]
             construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 350 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 550 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 650 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 51 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 114 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 159 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 164 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 221 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 266 dy 50 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 338 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 338 dy 16.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 370 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 403 dy 50 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 485 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 515 dy 36 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 583 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 633 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 638 dy 23 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 664 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 720 layer deco atlas hddecos }
            ]
            workstations [ { dx 78 anim peepworkf } { dx 260 anim peepworkb } { dx 357 anim peepworkl } { dx 460 anim peepworkl } ]
            serviceanchors [ { dx 47 tasktype servicecomputer } { dx 357 plusorminus 150 tasktype servicejanitor } { dx 357 plusorminus 150 tasktype servicesecurity } { dx 586 tasktype servicecatering } { dx 409 } ]
        }
        office-level-three-d-two {
            open [
                { img "office-3d-2.png" layer wallpaper atlas hdcom }
                { img "office-3d-left.png" layer foreground atlas hddecos }
                { img "office-3d-props-left.png" dx 32 layer deco atlas hddecos }
                { img "chair-desk-9.png" dx 247 layer deco atlas hddecos }
                { img "chair-desk-10.png" dx 350 layer deco atlas hddecos }
                { img "chair-desk-10.png" dx 452 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 500 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 700 layer grime atlas hdgrime }
            ]
             construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 350 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 550 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 650 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 51 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 114 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 159 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 164 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 221 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 266 dy 50 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 338 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 338 dy 16.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 370 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 403 dy 50 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 485 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 515 dy 36 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 583 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 633 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 638 dy 23 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 664 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 720 layer deco atlas hddecos }
            ]
            workstations [ { dx 78 anim peepworkf } { dx 260 anim peepworkb } { dx 357 anim peepworkl } { dx 460 anim peepworkl } ]
            serviceanchors [ { dx 47 tasktype servicecomputer } { dx 357 plusorminus 150 tasktype servicejanitor } { dx 357 plusorminus 150 tasktype servicesecurity } { dx 586 tasktype servicecatering } { dx 409 } ]
        }
        office-level-three-d-three {
            open [
                { img "office-3d-3.png" layer wallpaper atlas hdcom }
                { img "office-3d-left.png" layer foreground atlas hddecos }
                { img "office-3d-props-left.png" dx 32 layer deco atlas hddecos }
                { img "chair-desk-9.png" dx 247 layer deco atlas hddecos }
                { img "chair-desk-10.png" dx 350 layer deco atlas hddecos }
                { img "chair-desk-10.png" dx 452 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 150 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 500 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 700 layer grime atlas hdgrime }
            ]
             construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 350 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 550 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 650 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 51 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 114 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 159 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 164 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 221 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 266 dy 50 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 338 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 338 dy 16.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 370 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 403 dy 50 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 485 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 515 dy 36 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 583 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 633 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 638 dy 23 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 664 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 720 layer deco atlas hddecos }
            ]
            workstations [ { dx 78 anim peepworkf } { dx 260 anim peepworkb } { dx 357 anim peepworkl } { dx 460 anim peepworkl } ]
            serviceanchors [ { dx 47 tasktype servicecomputer } { dx 357 plusorminus 150 tasktype servicejanitor } { dx 357 plusorminus 150 tasktype servicesecurity } { dx 586 tasktype servicecatering } { dx 409 } ]
        }
        office-level-three-e {
            open [
                { img "office-3e.png" layer wallpaper atlas hdcom }
                { img "office-3e-left.png" layer foreground atlas hddecos }
                { img "office-3e-props-left.png" dx 138 layer deco atlas hddecos }
                { img "office-3e-props-right.png" dx 650 layer deco atlas hddecos }
                { img "grime-1a.png" layer grime atlas hdgrime }
                { img "grime-3b.png" dx 50 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 200 layer grime atlas hdgrime }
                { img "grime-4b.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 600 layer grime atlas hdgrime }
            ]
             construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 350 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 550 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 650 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 51 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 114 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 159 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 164 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 221 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 266 dy 50 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 338 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 338 dy 16.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 370 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 403 dy 50 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 485 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 515 dy 36 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 583 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 633 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 638 dy 23 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 664 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 720 layer deco atlas hddecos }
            ]
            workstations [ { dx 183 anim peepworkf } { dx 385 anim peepworkr } { dx 698 anim peepworkf } ]
            serviceanchors [ { dx 170 } { dx 357 plusorminus 150 tasktype servicejanitor } { dx 357 plusorminus 150 tasktype servicesecurity } { dx 55 tasktype servicecomputer } ]
        }
        office-level-three-f {
            open [
                { img "office-3c.png" layer wallpaper atlas hdcom }
                { img "office-3c-left.png" layer foreground atlas hddecos }
                { img "office-3f-deco.png" dx 72 dy 87 layer worker atlas hddecos }
                { img "office-3f-props-left.png" dx 31 layer deco atlas hddecos }
                { img "office-3f-props-center.png" dx 196 layer deco atlas hddecos }
                { img "chair-desk-3.png" dx 523 layer deco atlas hddecos }
                { img "chair-desk-7.png" dx 668 layer deco atlas hddecos }
                { img "grime-4a.png" layer grime atlas hdgrime }
                { img "grime-4b.png" dx 200 layer grime atlas hdgrime }
                { img "grime-3b.png" dx 400 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 550 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 700 layer grime atlas hdgrime }
            ]
            construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 150 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 250 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 350 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 450 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 550 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 650 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 51 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 114 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 159 layer deco atlas hddecos }
                { img "uc-box-2.png" dx 164 dy 58.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 221 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 266 dy 50 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 338 layer deco atlas hddecos }
                { img "uc-box-5.png" dx 338 dy 16.5 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dx 370 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 403 dy 50 layer deco atlas hddecos }
                { img "uc-pallet-drywall.png" dx 485 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 515 dy 36 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 583 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 633 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 638 dy 23 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 664 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 720 layer deco atlas hddecos }
            ]
            workstations [ { dx 76 anim peepworkf } { dx 240 anim peepworkf} { dx 530 anim peepworkl } { dx 680 anim peepworkb } ]
            serviceanchors [ { dx 81 } { dx 357 plusorminus 150 tasktype servicejanitor } { dx 357 plusorminus 150 tasktype servicesecurity } { dx 259 tasktype servicetemps } { dx 259 tasktype servicefitness } ]
            visitoranchors [ { dx 95 } { dx 375 } ]
        }

		office-level-four-a {
            open [
                { img "office-4a.png" layer wallpaper atlas hdtwofloors }
                { img "office-4a-left.png" layer foreground atlas hddecos }
                { img "office-4a-props.png" dx 33 layer deco atlas hddecos }
                { img "chair-desk-18.png" dx 280 layer deco atlas hddecos }
                { img "chair-desk-19.png" dx 347 layer deco atlas hddecos }
                { img "chair-desk-19.png" dy 150 dx 246 layer deco atlas hddecos }
                { img "chair-desk-19.png" dy 150 dx 289 layer deco atlas hddecos }
                { img "chair-desk-19.png" dy 150 dx 331 layer deco atlas hddecos }
                { img "chair-desk-18.png" dy 150 dx 380 layer deco atlas hddecos }
                { img "grime-1a.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 50 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 250 layer grime atlas hdgrime }
                { img "grime-2a.png" dx 400 layer grime atlas hdgrime }
                { img "grime-1b.png" dy 150 layer grime atlas hdgrime }
                { img "grime-4b.png" dy 150 dx 50 layer grime atlas hdgrime }
                { img "grime-3b.png" dy 150 dx 250 layer grime atlas hdgrime }
                { img "grime-2b.png" dy 150 dx 400 layer grime atlas hdgrime }
            ]
            construction [
                { img "middlefloor-10w.png" dy 146 layer worker atlas hdwalls }
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-door-second-office.png" dy 141.5 layer wallpaper atlas hdwalls }
                { img "uc-office-1w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 400 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 55 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 134 layer deco atlas hddecos }
                { img "uc-box-2.png" dy 56 dx 134 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 211 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dy 47.5 dx 254 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 340 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 423 layer deco atlas hddecos }
                { img "uc-box-2.png" dy 58.5 dx 456 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dy 150 dx 76 layer deco atlas hddecos }
                { img "uc-box-4.png" dy 204.5 dx 115 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dy 150 dx 149 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dy 150 dx 220 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dy 196 dx 279 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dy 150 dx 398 layer deco atlas hddecos }
                { img "uc-light.png" dy 150 dx 442 layer deco atlas hddecos }
            ]
            workstations [
                { dx 80 anim peepworkf }
                { dx 286 anim peepworkl }
                { dx 367 anim peepworkb }
                { dx 265 dy 150 anim peepworkb }
                { dx 312 dy 150 anim peepworkb }
                { dx 353 dy 150 anim peepworkb }
                { dx 390 dy 150 anim peepworkl }
            ]
            visitoranchors [
                { dx 108 dy 150  } { dx 130 }
            ]
            serviceanchors [
                { dx 250 plusorminus 100 tasktype servicejanitor }
                { dx 275 dy 150 tasktype servicecatering }
                { dx 100 dy 150 tasktype servicesecurity }
                { dx 309 plusorminus 40 tasktype servicefitness }
                { dx 155 tasktype servicelimo }
            ]
        }
        office-level-four-b {
            open [
                { img "office-4b.png" layer wallpaper atlas hdtwofloors }
                { img "office-4b-left.png" layer foreground atlas hddecos }
                { img "office-4b-props.png" dy 150 dx 36 layer deco atlas hddecos }
                { img "chair-desk-20.png" dx 415 layer deco atlas hddecos }
                { img "chair-desk-21.png" dy 150 dx 308 layer deco atlas hddecos }
                { img "chair-desk-20.png" dy 150 dx 356 layer deco atlas hddecos }
                { img "chair-desk-20.png" dy 150 dx 427 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-2a.png" dx 150 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 250 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 450 layer grime atlas hdgrime }
                { img "grime-3b.png" dy 150 layer grime atlas hdgrime }
                { img "grime-2b.png" dy 150 dx 150 layer grime atlas hdgrime }
                { img "grime-4b.png" dy 150 dx 250 layer grime atlas hdgrime }
                { img "grime-1b.png" dy 150 dx 450 layer grime atlas hdgrime }
            ]
            construction [
                { img "middlefloor-10w.png" dy 146 layer worker atlas hdwalls }
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-door-second-office.png" dy 141.5 layer wallpaper atlas hdwalls }
                { img "uc-office-1w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 400 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 55 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 134 layer deco atlas hddecos }
                { img "uc-box-2.png" dy 56 dx 134 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 211 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dy 47.5 dx 254 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 340 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 423 layer deco atlas hddecos }
                { img "uc-box-2.png" dy 58.5 dx 456 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dy 150 dx 76 layer deco atlas hddecos }
                { img "uc-box-4.png" dy 204.5 dx 115 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dy 150 dx 149 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dy 150 dx 220 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dy 196 dx 279 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dy 150 dx 398 layer deco atlas hddecos }
                { img "uc-light.png" dy 150 dx 442 layer deco atlas hddecos }
            ]
            workstations [
                { dx 66 anim peepworkf }
                { dx 86 anim peepworkf }
                { dx 434 anim peepworkb }
                { dx 434 anim peepworkb }
                { dx 93 dy 150 anim peepworkf }
                { dx 319 dy 150 anim peepworkl }
                { dx 375 dy 150 anim peepworkb }
                { dx 446 dy 150 anim peepworkb }
            ]
            serviceanchors [
                { dx 610 tasktype servicewater }
                { dx 250 plusorminus 100 tasktype servicejanitor }
                { dx 380 tasktype servicecomputer }
                { dx 415 dy 150 tasktype servicedesign }
                { dx 85 tasktype servicesecurity }
                { dx 85 tasktype servicehelicopter }
            ]
            visitoranchors [
                { dx 415 dy 150 }
                { dx 85 }
                { dx 335 dy 150 }
            ]
        }
        office-level-four-c {
            open [
                { img "office-4c.png" layer wallpaper atlas hdtwofloors }
                { img "office-4c-left.png" layer foreground atlas hddecos }
                { img "office-4c-props-left.png" dx 92 layer deco atlas hddecos } 
                { img "office-4c-props-right.png" dx 321 layer deco atlas hddecos }
                { img "chair-desk-18.png" dy 150 dx 75 layer deco atlas hddecos }
                { img "chair-desk-19.png" dy 150 dx 209 layer deco atlas hddecos }
                { img "grime-2a.png" layer grime atlas hdgrime }
                { img "grime-4a.png" dx 100 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 300 layer grime atlas hdgrime }
                { img "grime-3a.png" dx 350 layer grime atlas hdgrime }
                { img "grime-2b.png" dy 150 layer grime atlas hdgrime }
                { img "grime-4b.png" dy 150 dx 100 layer grime atlas hdgrime }
                { img "grime-1b.png" dy 150 dx 300 layer grime atlas hdgrime }
                { img "grime-3b.png" dy 150 dx 350 layer grime atlas hdgrime }
            ]
            construction [
                { img "middlefloor-10w.png" dy 146 layer worker atlas hdwalls }
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-door-second-office.png" dy 141.5 layer wallpaper atlas hdwalls }
                { img "uc-office-1w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 400 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 55 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 134 layer deco atlas hddecos }
                { img "uc-box-2.png" dy 56 dx 134 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 211 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dy 47.5 dx 254 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 340 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 423 layer deco atlas hddecos }
                { img "uc-box-2.png" dy 58.5 dx 456 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dy 150 dx 76 layer deco atlas hddecos }
                { img "uc-box-4.png" dy 204.5 dx 115 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dy 150 dx 149 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dy 150 dx 220 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dy 196 dx 279 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dy 150 dx 398 layer deco atlas hddecos }
                { img "uc-light.png" dy 150 dx 442 layer deco atlas hddecos }
            ]
            workstations [
                { dx 131 anim peepworkf }
                { dx 206 anim peepworkf }
                { dx 265 anim peepworkf }
                { dx 369 anim peepworkf }
                { dx 86 dy 150 anim peepworkl }
                { dx 227 dy 150 anim peepworkb }
                { dx 384 dy 150 anim peepworkf }
            ]
            serviceanchors [
                { dx 250 plusorminus 100 tasktype servicejanitor }
                { dx 340 tasktype serviceprinter }
                { dx 130 dy 150 tasktype serviceauditors }
                { dx 390 tasktype servicetemps }
                { dx 390 dy 150 tasktype servicesecurity }
            ]
            visitoranchors [
                { dx 68 }
                { dx 130 }
                { dx 240 plusorminus 30 }
            ]
        }
        office-level-four-d {
            open [
                { img "office-4d.png" layer wallpaper atlas hdtwofloors }
                { img "office-4d-left.png" layer foreground atlas hddecos }
                { img "office-4d-props-left.png" dx 31 layer deco atlas hddecos }
                { img "office-4d-props-right.png" dx 317 layer deco atlas hddecos }
                { img "office-4d-props-top.png" dy 150 dx 243 layer deco atlas hddecos }
                { img "chair-desk-20.png" dy 150 dx 59 layer deco atlas hddecos }
                { img "grime-3a.png" layer grime atlas hdgrime }
                { img "grime-2a.png" dx 150 layer grime atlas hdgrime }
                { img "grime-1a.png" dx 250 layer grime atlas hdgrime }
                { img "grime-4a.png" dx 300 layer grime atlas hdgrime }
                { img "grime-3b.png" dy 150 layer grime atlas hdgrime }
                { img "grime-2b.png" dy 150 dx 150 layer grime atlas hdgrime }
                { img "grime-1b.png" dy 150 dx 250 layer grime atlas hdgrime }
                { img "grime-4b.png" dy 150 dx 300 layer grime atlas hdgrime }
            ]
            construction [
                { img "middlefloor-10w.png" dy 146 layer worker atlas hdwalls }
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "zoned-door-second-office.png" dy 141.5 layer wallpaper atlas hdwalls }
                { img "uc-office-1w.png" dy 150 dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dy 150 dx 400 layer wallpaper atlas hdwalls }
                { img "uc-ladder.png" dx 55 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 134 layer deco atlas hddecos }
                { img "uc-box-2.png" dy 56 dx 134 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 211 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dy 47.5 dx 254 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 340 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dx 423 layer deco atlas hddecos }
                { img "uc-box-2.png" dy 58.5 dx 456 layer deco atlas hddecos }
                { img "uc-crate-chair.png" dy 150 dx 76 layer deco atlas hddecos }
                { img "uc-box-4.png" dy 204.5 dx 115 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dy 150 dx 149 layer deco atlas hddecos }
                { img "uc-crate-desk.png" dy 150 dx 220 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dy 196 dx 279 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dy 150 dx 398 layer deco atlas hddecos }
                { img "uc-light.png" dy 150 dx 442 layer deco atlas hddecos }
            ]
            workstations [
                { dx 72.5 anim peepworkf }
                { dx 280 anim peepworkf }
                { dx 280 anim peepworkf }
                { dx 368 anim peepworkf }
                { dx 78 dy 150 anim peepworkb }
                { dx 294 dy 150 anim peepworkf }
            ]
            serviceanchors [
                { dx 250 plusorminus 100 tasktype servicejanitor }
                { dx 240 dy 150 tasktype serviceauditors }
                { dx 440 dy 150 tasktype servicesecurity }
                { dx 55 tasktype servicehelicopter }
                { dx 104 tasktype servicelimo }
            ]
            visitoranchors [
                { dx 75 }
                { dx 340 }
            ]
        }


		;; ----------------------------------------------------------------

		;; entertainment

		entertainment-level-one {
			open [ { img "unit-ent-level1.png" layer wallpaper } ]
			construction [ { img "uc-4.png" layer wallpaper } ]
		}

        ;; ----------------------------------------------------------------

        ;; consultants

        consultant-aesthetics {
            open [
                { img "cons-a-decorator.png" layer wallpaper atlas hdwalls }
                { img "chair-desk-14.png" dx 122 layer deco atlas hddecos }
                { img "consultant_aes_left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 28 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 88 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 115 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 160 dy 50 layer deco atlas hddecos }
            ]
            workstations [ { dx 141 anim peepworkb } ]
        }
        consultant-aesthetics-dealer {
            open [
                { img "cons-a-dealer.png" layer wallpaper atlas hdwalls }
                { img "cons-a-dealer-props.png" dx 39 layer deco atlas hddecos }
                { img "chair-desk-13.png" dx 451 layer deco atlas hddecos }
                { img "consultant_aes_left.png" layer foreground atlas hddecos }
            ]
             construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 43 layer wallpaper atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 109 dy 50 layer wallpaper atlas hddecos }
                { img "uc-crate-short.png" dx 163 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 174 dy 58.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 223 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 282 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 291 dy 48 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 325 dy 48 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 368 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 395 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 445 layer deco atlas hddecos }
            ]
            workstations [ { dx 76 anim peepworkf } { dx 465 anim peepworkl } ]
            visitoranchors [ { dx 261 } {dx 309 } { dx 363 } ]
        }
        consultant-aesthetics-gallery {
             open [
                { img "cons-a-gallery.png" layer wallpaper atlas hdwalls }
                { img "consultant_aes_left.png" layer foreground atlas hddecos }
                { img "chair-desk-13.png" dx 103 layer deco atlas hddecos }
                { img "chair-desk-14.png" dx 523 layer deco atlas hddecos }
            ]
             construction [
                { img "uc-retail-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-retail-left.png" layer foreground atlas hddecos }
                { img "uc-retail-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-retail-2w.png" dx 500 layer wallpaper atlas hdwalls }
                { img "uc-dolly-crate.png" dx 35 layer deco atlas hddecos hflip #true }
                { img "uc-crate-desk.png" dx 106 layer deco atlas hddecos }
                { img "uc-crate-short.png" dx 215 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 279 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 346 layer deco atlas hddecos }
                { img "uc-dolly.png" dx 397 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 443 layer deco atlas hddecos }
                { img "uc-crate-tall.png" dx 545 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 139 dy 50 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 229 dy 58.5 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 353 dy 93.5 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 450 dy 48 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 486 dy 48 layer deco atlas hddecos }
                { img "uc-box-4.png" dx 551 dy 93.5 layer deco atlas hddecos }
            ]
            workstations [ { dx 112 anim peepworkl } { dx 540 anim peepworkb } ]
            visitoranchors [ { dx 250 } { dx 289 } { dx 340 } { dx 384 } { dx 431 } ]
        }
        consultant-civics {
            open [
                { img "cons-c.png" layer wallpaper atlas hdwalls }
                { img "cons-c-props.png" dx 31 layer deco atlas hddecos }
                { img "chair-desk-17.png" dx 280 layer deco atlas hddecos }
                { img "chair-desk-16.png" dx 412 layer deco atlas hddecos }
                { img "consultant_civ_left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-office-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-office-left.png" layer foreground atlas hddecos }
                { img "uc-office-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-office-2w.png" dx 400 layer wallpaper atlas hdwalls }
                { img "uc-crate-desk.png" dx 43 layer wallpaper atlas hddecos }
                { img "uc-toolbox-hammer.png" dx 109 dy 50 layer wallpaper atlas hddecos }
                { img "uc-crate-short.png" dx 163 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 174 dy 58.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 223 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 282 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 291 dy 48 layer deco atlas hddecos }
                { img "uc-box-3.png" dx 325 dy 48 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 368 layer deco atlas hddecos }
                { img "uc-drywall-tools.png" dx 395 layer deco atlas hddecos }
                { img "uc-dolly-crate.png" dx 445 layer deco atlas hddecos }
            ]
            workstations [ { dx 72 anim peepworkf } { dx 292 anim peepworkl } { dx 432 anim peepworkb } ]
            visitoranchors [ { dx 80 plusorminus 10 } ]
        }
        consultant-building {
            open [
                { img "cons-b-building-manager.png" layer wallpaper atlas hdwalls }
                { img "cons-b-building-manager-props.png" dx 108 layer deco atlas hddecos }
                { img "chair-desk-7.png" dx 319 layer deco atlas hddecos }
                { img "consultant_bldg_left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-restaurant-door.png" layer wallpaper atlas hdwalls }
                { img "zoned-restaurant-left.png" layer foreground atlas hddecos }
                { img "uc-restaurant-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 100 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 200 layer wallpaper atlas hdwalls }
                { img "uc-restaurant-2w.png" dx 300 layer wallpaper atlas hdwalls }
                { img "uc-crate-chair.png" dx 25 layer deco atlas hddecos }
                { img "uc-toolbox-open.png" dx 63 dy 51.5 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 109 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 172 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 266 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 180 dy 48 layer deco atlas hddecos }
                { img "uc-crate-long.png" dx 214 dy 48 layer deco atlas hddecos }
                { img "uc-bucket-paint.png" dx 309 dy 48 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 360 layer deco atlas hddecos }
            ]
            workstations [ { dx 147 anim peepworkf } { dx 336 anim peepworkb } ]
        }


        ;; fountains etc

        fountain-indoor-one {
            open [
                { img "art-fountain-one.png" layer wallpaper atlas hddecos }
                { img "art-fountain-one-water.png" dy 44.5 dx 25 layer deco atlas hddecos framecount 3 fps 5 }
            ]
        }
        fountain-indoor-two {
            open [
                { img "art-fountain-two.png" layer wallpaper atlas hddecos }
                { img "art-fountain-two-water.png" dy 38.5 dx 19 layer deco atlas hddecos framecount 3 fps 5 }
            ]
        }
        fountain-indoor-three {
            open [
                { img "art-fountain-three.png" layer wallpaper atlas hddecos }
                { img "art-fountain-three-water.png" dy 22.5 dx 20.5 layer deco atlas hddecos framecount 3 fps 5 }
            ]
        }
        plaza-fountain-two {
            open [ 
                { img "plaza-fountain-two.png" layer wallpaper atlas hddecos } 
                { img "plaza-fountain-two-water.png" dy 0 dx 65 layer deco atlas hddecos framecount 3 fps 5 }
            ]
        }
        plaza-fountain-one {
            open [
                { img "plaza-fountain-one.png" layer wallpaper atlas hddecos }
                { img "plaza-fountain-one-water.png" dy 69 dx 95 layer deco atlas hddecos framecount 3 fps 5 }
            ]
        }
        plaza-fountain-three {
            open [
                { img "plaza-fountain-three.png" layer wallpaper atlas hddecos }
                { img "plaza-fountain-three-water.png" dy 51.5 dx 42.5 layer deco atlas hddecos framecount 3 fps 5 }
            ]
        }
        fountain-cubist {
            open [
                { img "fountain.png" atlas preorder layer wallpaper }
                { img "water.png" atlas preorder layer
                 deco framecount 3 fps 5 }
            ]
        }

        ;; amenities

        amenity-vending-soda {
            open [
                { img "amenity-vending-soda.png" layer wallpaper atlas hdservices }
                { img "vending-left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-toolbox.png" dx 60 layer deco atlas hddecos }
            ]
            patronanchors [
                { dx 65 animm "res-stand-back-m" animf "res-stand-back-f" }
            ]
        }
        amenity-vending-smokes {
            open [
                { img "amenity-vending-smokes.png" layer wallpaper atlas hdservices }
                { img "vending-left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-toolbox.png" dx 60 layer deco atlas hddecos }
            ]
            patronanchors [
                { dx 66 animm "res-stand-back-m" animf "res-stand-back-f" }
            ]
        }
        amenity-vending-drinks {
            open [
                { img "amenity-vending-drinks.png" layer wallpaper atlas hdservices }
                { img "vending-left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-toolbox.png" dx 60 layer deco atlas hddecos }
            ]
            patronanchors [
                { dx 60 animm "res-stand-back-m" animf "res-stand-back-f" }
            ]
        }
        amenity-vending-candy {
            open [
                { img "amenity-vending-candy.png" layer wallpaper atlas hdservices }
                { img "vending-left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-toolbox.png" dx 60 layer deco atlas hddecos }
            ]
            patronanchors [
                { dx 66 animm "res-stand-back-m" animf "res-stand-back-f" }
            ]
        }
        amenity-phones {
            open [
                { img "amenity-phones.png" layer wallpaper atlas hdservices }
                { img "vending-left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-toolbox.png" dx 60 layer deco atlas hddecos }
            ]
            patronanchors [
                { dx 48 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 75 animm "res-stand-back-m" animf "res-stand-back-f" }
            ]
        }

        ;; amenities - retail

        amenity-retail-snacks {
            open [
                { img "amenity-retail-snacks.png" layer wallpaper atlas hdservices }
                { img "amenities-left-1.png" layer foreground atlas hddecos }
                { img "amenity-retail-snacks-props.png" dx 30.5 layer deco atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-toolbox.png" dx 34 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 85 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 116 layer deco atlas hddecos }
            ]
            workstations [
                { dx 60 anim peepworkf }
            ]
            patronanchors [
                { dx 60 animm "res-stand-back-m" animf "res-stand-back-f" }
            ]
        }
        amenity-retail-news {
            open [
                { img "amenity-retail-news.png" layer wallpaper atlas hdservices }
                { img "amenities-left-1.png" layer foreground atlas hddecos }
                { img "amenity-retail-news-props.png" dx 58.5 layer deco atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-toolbox.png" dx 34 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 85 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 116 layer deco atlas hddecos }
            ]
            workstations [
                { dx 80 anim peepworkf }
            ]
            patronanchors [
                { dx 75 animm "res-stand-back-m" animf "res-stand-back-f" }
            ]
        }
        amenity-shoeshine {
            open [
                { img "amenity-shoeshine.png" layer wallpaper atlas hdservices }
                { img "amenities-left-2.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-toolbox.png" dx 34 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 85 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 116 layer deco atlas hddecos }
            ]
            workstations [
                { dx 88 anim peepworkf }
            ]
            patronanchors [
                { dx 53 dy 23 animm "eat-sit-f-m" animf "eat-sit-f-f" }
                { dx 120 dy 23 animm "eat-sit-f-m" animf "eat-sit-f-f" }
            ]
        }

        ;; amenities - common areas

        common-area-darts {
            open [
                { img "common-area-darts.png" layer wallpaper atlas hdservices }
                { img "common-area-left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-toolbox.png" dx 34 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 85 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 116 layer deco atlas hddecos }
            ]
            patronanchors [
                { dx 57 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" }
                { dx 110 animm "res-stand-back-m" animf "res-stand-back-f" }
            ]
        }
        common-area-reading {
            open [
                { img "common-area-reading.png" layer wallpaper atlas hdservices }
                { img "common-area-left.png" layer foreground atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-toolbox.png" dx 34 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 85 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 116 layer deco atlas hddecos }
            ]
            patronanchors [
                { dx 75 animm "res-stand-back-m" animf "res-stand-back-f" }
                { dx 126 animm "res-sit-relax-front-m" animf "res-sit-relax-front-f" }
            ]
        }
        common-area-bar {
            open [
                { img "common-area-bar.png" layer wallpaper atlas hdservices }
                { img "common-area-left.png" layer foreground atlas hddecos }
                { img "stool-2.png" dx 38.5 layer deco atlas hddecos }
                { img "stool-2.png" dx 67.5 layer deco atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-toolbox.png" dx 34 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 85 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 116 layer deco atlas hddecos }
            ]
            patronanchors [
                { dx 50 dy 9 animm "eat-sit-b-m" animf "eat-sit-b-f" }
                { dx 79 dy 9 animm "eat-sit-b-m" animf "eat-sit-b-f" }
            ]
        }
        common-area-fireplace {
            open [
                { img "common-area-fireplace.png" layer wallpaper atlas hdservices }
                { img "common-area-left.png" layer foreground atlas hddecos }
                { img "fire.png" dx 114 layer deco atlas hddecos framecount 3 fps 5 }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-2w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-toolbox.png" dx 34 layer deco atlas hddecos }
                { img "uc-box-1.png" dx 85 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 116 layer deco atlas hddecos }
            ]
            patronanchors [
                { dx 57 animm "res-sit-relax-r-m" animf "res-sit-relax-r-f" }
                { dx 124 animm "res-stand-back-m" animf "res-stand-back-f" }
            ]
        }

        ;; animated decos

        xmastree-outside {
            open [
                { img "deco-winter-christmas-tree-outside.png" dy 5 layer wallpaper atlas hdseasonal }
                { img "deco-winter-christmas-tree-outside-lights.png" dy 5 layer deco atlas hdseasonal framecount 3 fps 2 }
            ]
        }

        ;; amenities - custodian

        amenity-broomcloset {
            open [
                { img "amenity-broomcloset.png" layer wallpaper atlas hdservices }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-1w.png" dx 50 layer wallpaper atlas hdwalls }
                { img "uc-toolbox.png" layer deco atlas hddecos }
            ]
            serviceanchors [ { dx 75 } ]
        }
        amenity-custodian {
            open [
                { img "amenity-custodian.png" layer wallpaper atlas hdservices }
                { img "amenities-custodian-props.png" dx 215 layer deco atlas hddecos }
                { img "custodian-mop-zero.png" dx 105 layer deco atlas hddecos }
                { img "custodian-mop-one.png" dx 105 layer deco atlas hddecos }
                { img "custodian-mop-two.png" dx 105 layer deco atlas hddecos }
                { img "custodian-mop-three.png" dx 105 layer deco atlas hddecos }
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-2w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 150 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-shovel.png" dx 39 layer deco atlas hddecos } 
                { img "uc-pallet-concrete.png" dx 52 layer deco atlas hddecos }
                { img "uc-bucket-trowel.png" dx 125 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 160 layer deco atlas hddecos }
                { img "uc-light.png" dx 199 layer deco atlas hddecos }
             ]
             workstations [
                { dx 278 anim peepworkf }
             ]
        }

        ;; spawners

        spawner-metro {
            open [
                { img "metro.png" layer wallpaper atlas hdwalls }
                { img "trash-left.png" layer foreground atlas hddecos }
                { img "metro-props.png" dx 254 layer deco atlas hddecos }                
            ]
            construction [
                { img "uc-door-left.png" layer wallpaper atlas hdwalls }
                { img "uc-left.png" layer foreground atlas hddecos }
                { img "uc-lights-1w.png" dx 50 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 100 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 200 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 300 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 400 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-lights-2w.png" dx 500 dy 110 layer wallpaper atlas hdwalls }
                { img "uc-shovel.png" dx 30 layer deco atlas hddecos }
                { img "uc-pallet-concrete.png" dx 52 layer deco atlas hddecos }
                { img "uc-trash-open.png" dx 146 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 189 layer deco atlas hddecos }
                { img "uc-planks-tools.png" dx 234 layer deco atlas hddecos }
                { img "uc-ladder.png" dx 300 layer deco atlas hddecos }
                { img "uc-buckets-paint.png" dx 368 layer deco atlas hddecos }
                { img "uc-pallet-concrete.png" dx 405 layer deco atlas hddecos }
                { img "uc-concrete-sacks.png" dx 508 layer deco atlas hddecos }
                { img "uc-light.png" dx 540 layer deco atlas hddecos }
            ]
            workstations [
                { dx 282 anim peepworkf } { dx 328 anim peepworkf } { dx 282 anim peepworkf } { dx 328 anim peepworkf }
            ]
            
        }

        ;; Backdrop stuff

        backdrop-building-one-ground-floor {
            open [ { img "building-one-ground-floor.png" atlas backdropbuildings } ]
        }

        backdrop-building-one-second-floor {
            open [ { img "building-one-second-floor.png" atlas backdropbuildings dx -49.5 } ]
        }

        backdrop-building-one-repeat-floor {
            open [ { img "building-one-repeat-floor.png" atlas backdropbuildings } ]
        }

        backdrop-building-one-roof {
            open [ { img "building-one-roof.png" atlas backdropbuildings } ]
        }

        backdrop-building-one-roof-rear-layers {
            open [ { img "building-one-roof-rear-layers.png" atlas backdropbuildings } ]
        }

        backdrop-building-two-ground-floor {
            open [ { img "building-two-ground-floor.png" atlas backdropbuildings } ]
        }

        backdrop-building-two-second-floor {
            open [ { img "building-two-second-floor.png" atlas backdropbuildings dx -43 } ]
        }

        backdrop-building-two-repeat-floor {
            open [ { img "building-two-repeat-floor.png" atlas backdropbuildings } ]
        }

        backdrop-building-two-roof {
            open [ { img "building-two-roof.png" atlas backdropbuildings } ]
        }

        backdrop-building-two-roof-rear-layers {
            open [ { img "building-two-roof-rear-layers" atlas backdropbuildings } ]
        }

        backdrop-building-three-ground-floor {
            open [ { img "building-three-ground-floor.png" atlas backdropbuildings dx -12 dy 8.5 } ]
        }

        backdrop-building-three-second-floor {
            open [ { img "building-three-second-floor.png" atlas backdropbuildings dx -54.5 dy -2.5 } ]
        }

        backdrop-building-three-repeat-floor {
            open [ { img "building-three-repeat-floor.png" atlas backdropbuildings dy -2.5 } ]
        }

        backdrop-building-three-roof {
            open [ { img "building-three-roof.png" atlas backdropbuildings dx -11 dy 5 } ]
        }

        backdrop-building-three-roof-rear-layers {
            open [ { img "building-three-roof-rear-layers" atlas backdropbuildings } ]
        }

        backdrop-building-four-ground-floor {
            open [ { img "building-four-ground-floor.png" atlas backdropbuildings } ]
        }

        backdrop-building-four-second-floor {
            open [ { img "building-four-second-floor.png" atlas backdropbuildings dx -67 } ]
        }

        backdrop-building-four-repeat-floor {
            open [ { img "building-four-repeat-floor.png" atlas backdropbuildings dx 8 dy -24 } ]
        }

        backdrop-building-four-roof {
            open [ { img "building-four-roof.png" atlas backdropbuildings dx -0.5 dy -20 } ]
        }

        backdrop-building-four-roof-rear-layers {
            open [ { img "building-four-roof-rear-layers" atlas backdropbuildings } ]
        }

        backdrop-building-five-ground-floor {
            open [ { img "building-five-ground-floor.png" atlas backdropbuildings } ]
        }

        backdrop-building-five-second-floor {
            open [ { img "building-five-second-floor.png" atlas backdropbuildings dx -75 } ]
        }

        backdrop-building-five-repeat-floor {
            open [ { img "building-five-repeat-floor.png" atlas backdropbuildings } ]
        }

        backdrop-building-five-roof {
            open [ { img "building-five-roof.png" atlas backdropbuildings } ]
        }

        backdrop-building-five-roof-rear-layers {
            open [ { img "building-five-roof-rear-layers" atlas backdropbuildings } ]
        }

        backdrop-building-six-ground-floor {
            open [ { img "building-six-ground-floor.png" atlas backdropbuildings } ]
        }

        backdrop-building-six-second-floor {
            open [ { img "building-six-second-floor.png" atlas backdropbuildings dx -30.5 } ]
        }

        backdrop-building-six-repeat-floor {
            open [ { img "building-six-repeat-floor.png" atlas backdropbuildings dx 12 dy -21.5 } ]
        }

        backdrop-building-six-roof {
            open [ { img "building-six-roof.png" atlas backdropbuildings dx 3 dy -15.5 } ]
        }

        backdrop-building-six-roof-rear-layers {
            open [ { img "building-six-roof-rear-layers" atlas backdropbuildings dx 3 dy -15.5 } ]
        }

        backdrop-monster {
            open [ 
                { img "zilla-bottom.png" layer backdropclouds }
                { img "zilla-top-walk.png" layer backdropclouds dx 166 dy 280 }
            ]
            closed [ 
                { img "zilla-bottom.png" layer backdropclouds }
                { img "zilla-top-look.png" layer backdropclouds dx 166 dy 280 }
            ]
        }
	}
}
